/*
 * @author lsy
 * @date   2019-11-18
 **/
class PutImageDataBean {
  Result result;

  PutImageDataBean({this.result});

  PutImageDataBean.fromJson(Map<String, dynamic> json) {
    result =
    json['result'] != null ? new Result.fromJson(json['result']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.result != null) {
      data['result'] = this.result.toJson();
    }
    return data;
  }
}

class Result {
  String url;
  FaceDetails faceDetails;

  Result({this.url, this.faceDetails});

  Result.fromJson(Map<String, dynamic> json) {
    url = json['url'];
    faceDetails = json['face_details'] != null
        ? new FaceDetails.fromJson(json['face_details'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['url'] = this.url;
    if (this.faceDetails != null) {
      data['face_details'] = this.faceDetails.toJson();
    }
    return data;
  }
}

class FaceDetails {
  String eyelidRight;
  String eyelidLeft;
  String nose;
  String wrink;
  String lipThickness;
  String lipPeak;
  String pouch;
  String cheekbone;
  String browShape;
  String browDensity;
  String chinShape;
  String lipShape;
  String lipRadian;
  String eyeShapeRight;
  String eyeShapeLeft;
  String eyebrowstyle;
  String eyebrowthickness;
  String eyebrowsconcentration;
  String brow;
  String eyeDistance;
  String face;

  FaceDetails(
      {this.eyelidRight,
        this.eyelidLeft,
        this.nose,
        this.wrink,
        this.lipThickness,
        this.lipPeak,
        this.pouch,
        this.cheekbone,
        this.browShape,
        this.browDensity,
        this.chinShape,
        this.lipShape,
        this.lipRadian,
        this.eyeShapeRight,
        this.eyeShapeLeft,
        this.eyebrowstyle,
        this.eyebrowthickness,
        this.eyebrowsconcentration,
        this.brow,
        this.eyeDistance,
        this.face});

  FaceDetails.fromJson(Map<String, dynamic> json) {
    eyelidRight = json['eyelid_right'];
    eyelidLeft = json['eyelid_left'];
    nose = json['nose'];
    wrink = json['wrink'];
    lipThickness = json['lip_thickness'];
    lipPeak = json['lip_peak'];
    pouch = json['pouch'];
    cheekbone = json['cheekbone'];
    browShape = json['brow_shape'];
    browDensity = json['brow_density'];
    chinShape = json['chin_shape'];
    lipShape = json['lip_shape'];
    lipRadian = json['lip_radian'];
    eyeShapeRight = json['eye_shape_right'];
    eyeShapeLeft = json['eye_shape_left'];
    eyebrowstyle = json['Eyebrowstyle'];
    eyebrowthickness = json['eyebrowthickness'];
    eyebrowsconcentration = json['Eyebrowsconcentration'];
    brow = json['brow'];
    eyeDistance = json['eye_distance'];
    face = json['face'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['eyelid_right'] = this.eyelidRight;
    data['eyelid_left'] = this.eyelidLeft;
    data['nose'] = this.nose;
    data['wrink'] = this.wrink;
    data['lip_thickness'] = this.lipThickness;
    data['lip_peak'] = this.lipPeak;
    data['pouch'] = this.pouch;
    data['cheekbone'] = this.cheekbone;
    data['brow_shape'] = this.browShape;
    data['brow_density'] = this.browDensity;
    data['chin_shape'] = this.chinShape;
    data['lip_shape'] = this.lipShape;
    data['lip_radian'] = this.lipRadian;
    data['eye_shape_right'] = this.eyeShapeRight;
    data['eye_shape_left'] = this.eyeShapeLeft;
    data['Eyebrowstyle'] = this.eyebrowstyle;
    data['eyebrowthickness'] = this.eyebrowthickness;
    data['Eyebrowsconcentration'] = this.eyebrowsconcentration;
    data['brow'] = this.brow;
    data['eye_distance'] = this.eyeDistance;
    data['face'] = this.face;
    return data;
  }
}

