/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:ui';

import 'package:example_flutter/UserModel/page/login/LoginModel.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/base/BaseComponent.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class LoginPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => LoginState();
}

class LoginState extends State<LoginPage> {
  LoginModel _model;
  TextEditingController _nameCon;
  TextEditingController _wordCon;

  LoginState() {
    _model = LoginModel();
  }

  @override
  void initState() {
    super.initState();
    _nameCon = TextEditingController();
    _wordCon = TextEditingController();
  }

  @override
  void dispose() {
    super.dispose();
    _nameCon.dispose();
    _wordCon.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        body: Stack(
            alignment : AlignmentDirectional.topCenter,
      children: <Widget>[
        ConstrainedBox(
          constraints: BoxConstraints.expand(),
          child: BackdropFilter(
              filter: new ImageFilter.blur(sigmaX: 100, sigmaY: 100),
              child: Image.network(
                "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1573655792197&di=f9469fa087a082aedfd22514c1549e1f&imgtype=0&src=http%3A%2F%2Fimg8.zol.com.cn%2Fbbs%2Fupload%2F19571%2F19570481.jpg",
                fit: BoxFit.cover,
              )),
        ),
        main(),
//        Positioned(
//          child: Container(
//            height: 60,
//            alignment: Alignment.center,
//            child: FlatButton(
//              onPressed: (){
//                openCachce();
//              },
//              child: Container(
//                padding: EdgeInsets.all(10),
//                color: Colors.black,
//                child: baseText("请把opencv.sh 和 opencv.py 移动到打开的目标文件夹下！！ 点我打开目标文件夹", 15, Colors.redAccent),
//              ),
//            ),
//          ),
//        ),
      ],
    ));
  }

  main() {
    return Container(
        width: double.maxFinite,
        height: double.maxFinite,
        alignment: Alignment.center,
        child: Container(
          width: 600,
          height: 350,
          color: Colors.black38,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              Expanded(
                child: Container(),
              ),
              baseText("更美AI标注平台", 30, ALColors.ColorF8F8F8),
              Container(
                margin: EdgeInsets.only(
                    top: ScreenUtil.instance.setHeight(20),
                    left: ScreenUtil.instance.setWidth(100),
                    right: ScreenUtil.instance.setWidth(100)),
                child: TextField(
                  controller: _nameCon,
                  keyboardType: TextInputType.number,
                  cursorColor: Colors.white,
                  decoration: InputDecoration(
                      hoverColor: Colors.white,
                      fillColor: Colors.white,
                      focusColor: Colors.white,
                      contentPadding: EdgeInsets.all(10.0),
                      icon: Icon(
                        Icons.person,
                        size: ScreenUtil.instance.setSp(30),
                      ),
                      labelText: '请输入你的用户名',
//                  helperText: '请输入你的用户名',
                      labelStyle: TextStyle(color: Colors.white),
                      helperStyle: TextStyle(color: Colors.white)),
                  autofocus: false,
                ),
              ),
              Container(
                margin: EdgeInsets.only(
                    top: ScreenUtil.instance.setHeight(20),
                    left: ScreenUtil.instance.setWidth(100),
                    right: ScreenUtil.instance.setWidth(100)),
                child: TextField(
                  controller: _wordCon,
                  keyboardType: TextInputType.number,
                  cursorColor: Colors.white,
                  decoration: InputDecoration(
                      hoverColor: Colors.white,
                      fillColor: Colors.white,
                      focusColor: Colors.white,
                      contentPadding: EdgeInsets.all(10.0),
                      icon: Icon(
                        Icons.wb_cloudy,
                        size: ScreenUtil.instance.setSp(30),
                      ),
                      labelText: '请输入你的密码',
//                  helperText: '请输入你的用户名',
                      labelStyle: TextStyle(color: Colors.white),
                      helperStyle: TextStyle(color: Colors.white)),
                  autofocus: false,
                ),
              ),
              Container(
                  width: double.maxFinite,
                  height: ScreenUtil.instance.setHeight(130),
                  margin: EdgeInsets.only(
                      top: ScreenUtil.instance.setHeight(80),
                      left: ScreenUtil.instance.setWidth(100),
                      right: ScreenUtil.instance.setWidth(100)),
                  child: RaisedButton(
                    onPressed: () {
                      if (_nameCon.text.length == 0 ||
                          _wordCon.text.length == 0) {
                        Toast.show(context, "账号或者密码为空");
                        return;
                      }
                      BaseCenterPicker()
                        ..setPicker(BaseLoadingItem("加载中..."))
                        ..show(context);
                      _model.login(context, _nameCon.text, _wordCon.text);
                    },
                    color: Colors.deepOrange,
                    child: baseText("登入", ScreenUtil.instance.setSp(15),
                        ALColors.ColorFFFFFF),
                  )),
              Container(
                  width: double.maxFinite,
                  height: ScreenUtil.instance.setHeight(130),
                  margin: EdgeInsets.only(
                      top: ScreenUtil.instance.setHeight(20),
                      left: ScreenUtil.instance.setWidth(100),
                      right: ScreenUtil.instance.setWidth(100)),
                  child: RaisedButton(
                    color: Colors.deepPurpleAccent,
                    onPressed: () {
                      BaseCenterPicker()
                        ..setPicker(BaseLoadingItem("加载中..."))
                        ..show(context);
                      _model.resign(context, _nameCon.text, _wordCon.text);
                    },
                    child: baseText("注册", ScreenUtil.instance.setSp(15),
                        ALColors.ColorFFFFFF),
                  )),
              Expanded(
                child: Container(),
              ),
            ],
          ),
        ));
  }
}
