/*
 * @author lsy
 * @date   2019-11-22
 **/
import 'dart:ui' as ui;

class PointItem {
  List<ui.Offset> list = new List();
  ui.Image image;
  double x = -1;
  double y = -1;
  double scareSize = 1;
  double tranX = 0;
  double tranY = 0;
  bool drawPath = false;

  void reset() {
    list.clear();
    x = -1;
    y = -1;
    scareSize = 1;
    tranY = 0;
    tranX = 0;
    drawPath = false;
  }

  PointItem();

  setScareSize(double scareSize) {
    if (scareSize < 1) {
      scareSize = 1;
    }
    this.scareSize = scareSize;
  }

  double getScareSize() {
    return scareSize;
  }

  setTranX(double tranX) {
    if (tranX < 0) {
      tranX = 0;
    }
    this.tranX = tranX;
  }

  double getTranX() {
    return tranX;
  }

  setTranY(double tranY) {
    if (tranY < 0) {
      tranY = 0;
    }
    this.tranY = tranY;
  }

  double getTranY() {
    return tranY;
  }

  List<ui.Offset> getPoints() {
    return list;
  }

  addPoint(double x, double y) {
    double realX = (x + getTranX()) / scareSize;
    double realY = (y + getTranY()) / scareSize;
    list.add(new ui.Offset(realX, realY));
  }

  removePoint() {
    if (list.isNotEmpty) {
      list.removeAt(list.length - 1);
      drawPath = false;
    }
  }

  setImage(ui.Image image) {
    this.image = image;
  }

  ui.Image getImage() {
    return image;
  }

  setX(double x) {
    this.x = x;
  }

  setY(double y) {
    this.y = y;
  }

  double getX() {
    return x;
  }

  double getY() {
    return y;
  }

  void close() {
    if (list.isNotEmpty && list.length > 2) {
      list.add(list[0]);
      drawPath = true;
    }
  }
}
