/*
 * @author lsy
 * @date   2019-11-22
 **/
import 'dart:async';
import 'dart:ui';

import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:flutter/material.dart';
import 'dart:ui' as ui;

//
//class WorkViewController extends StatefulWidget {
//  @override
//  State<StatefulWidget> createState() => WorkViewState();
//}
//
//class WorkViewState extends State<WorkViewController> {
//  ui.Image img;
//
//  @override
//  void initState() {
//    super.initState();
//    String testImg =
//        "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1574413347096&di=44b91b322281ad449b4d93cf79df3d0c&imgtype=0&src=http%3A%2F%2Fpic27.nipic.com%2F20130324%2F9252150_152129329000_2.jpg";
//    loadImage(testImg).then((value) {
//      setState(() {
//        img = value;
//      });
//    });
//  }
//
//  @override
//  Widget build(BuildContext context) {
//    return CustomPaint(painter: WorkView(img));
//  }
//
//  Future<ui.Image> loadImage(var path) async {
//    ImageStream stream = NetworkImage(
//      path,
//    ).resolve(ImageConfiguration.empty);
//    Completer<ui.Image> completer = Completer<ui.Image>();
//    void listener(ImageInfo frame, bool synchronousCall) {
//      final ui.Image image = frame.image as ui.Image;
//      completer.complete(image);
//      stream.removeListener(ImageStreamListener(listener));
//    }
//
//    stream.addListener(ImageStreamListener(listener));
//    return completer.future;
//  }
//}

class WorkView extends CustomPainter {
  PointItem item;

  WorkView(this.item) {}
  Paint ImagePaint = new Paint()..isAntiAlias = true;
  Paint linePaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.black
    ..strokeWidth = 1;

  Paint pointPaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.red
    ..strokeWidth = 1;

  Paint pathPaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.black38
    ..style = PaintingStyle.fill;

  @override
  void paint(Canvas canvas, Size size) {
    if (item.tranX != 0 || item.tranY != 0) {
      if (item.tranX / item.scareSize > size.width) {
        item.tranX = size.width * item.scareSize;
      }
      if (item.tranY / item.scareSize > size.height) {
        item.tranY = size.height * item.scareSize;
      }
      canvas.translate(-item.tranX, -item.tranY);
    }
    if (item.scareSize != 1) {
      canvas.scale(item.scareSize, item.scareSize);
    }
    if (item.getImage() != null) {
      double scareSize = item.getImage().width / size.width;
      double showWidth = size.width;
      double showheight = item.getImage().height / scareSize;
      if (showheight > size.height) {
        showheight = size.height;
      }
      double top = (size.height - showheight) / 2;
      canvas.drawImageRect(
          item.getImage(),
          Rect.fromLTWH(0.0, 0.0, item.getImage().width.toDouble(),
              item.getImage().height.toDouble()),
          Rect.fromLTWH(0, top, showWidth, showheight),
          ImagePaint);
    }
    double newX = (item.getX() + item.getTranX()) / item.scareSize;
    double newY = (item.getY() + item.getTranY()) / item.scareSize;
    if (item.getX() != null &&
        item.getY() != null &&
        item.getX() >= 0 &&
        item.getY() >= 0) {
      canvas.drawLine(Offset(newX, 0), Offset(newX, size.height), linePaint);
      canvas.drawLine(Offset(0, newY), Offset(size.width, newY), linePaint);
      TextPainter(
          text: TextSpan(
              text: "${newX.toInt()},${newY.toInt()}",
              style: TextStyle(
                  fontSize: 15,
                  color: Colors.yellow,
                  fontWeight: FontWeight.w300)),
          textDirection: TextDirection.ltr,
          textAlign: TextAlign.center)
        ..layout(maxWidth: 150, minWidth: 30)
        ..paint(canvas, Offset(newX + 5, newY - 20));
    }
    if (item.getPoints().isNotEmpty) {
//      if(item.getPoints().length==1){
//        canvas.drawPoints(pointMode, points, paint)
//      }else if(item.getPoints().length==2){
//
//      } else{
//        for(int i=0;i<item.getPoints().length;i++){
//          if(i==item.getPoints().length-1){
//
//          }else{
//
//          }
//        }
//      }
      canvas.drawPoints(PointMode.polygon, item.getPoints(), pointPaint);
    }
    print("OK??  ${item.drawPath}");
    if (item.drawPath) {
      if (item.getPoints().length < 2) {
        return;
      }
      Path path = new Path();
      path.moveTo(item.getPoints()[0].dx, item.getPoints()[0].dy);
      for (int i = 0; i < item.getPoints().length; i++) {
        path.lineTo(item.getPoints()[i].dx, item.getPoints()[i].dy);
      }
      path.close();
      canvas.drawPath(path, pathPaint);
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) {
    return true;
  }
}
