/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'package:example_flutter/HomeModel/page/home/HomeModel.dart';
import 'package:example_flutter/HomeModel/page/picture/PicPage.dart';
import 'package:example_flutter/commonModel/base/BaseComponent.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';

class HomePage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => HomeState();
}

class HomeState extends State<HomePage> {
  HomeModel _model;
  Size screenSize;

  HomeState() {
    _model = new HomeModel();
  }

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    screenSize = MediaQuery.of(context).size;
    String userName =
        CacheManager.getInstance().get(MEMORY_CACHE).get("userName");
    return Scaffold(
//      appBar: AppBar(
//        leading: Text(""),
//          backgroundColor: ALColors.Color5276F4,
//          actions: <Widget>[
//            Expanded(
//              child: Container(),
//            ),
//            Container(
//              margin: EdgeInsets.only(right: ScreenUtil.instance.setWidth(10)),
//              alignment: Alignment.center,
//              child: baseText(userName, 30, ALColors.ColorF8F8F8),
//            ),
//            Container(
//              width: kToolbarHeight,
//              height: kToolbarHeight,
//              margin: EdgeInsets.only(
//                  left: ScreenUtil.instance.setWidth(5),
//                  right: ScreenUtil.instance.setWidth(50),
//                  top: 5,
//                  bottom: 5),
//              child: SvgPicture.asset("image/Face.svg"),
//            ),
//          ]),
      body: uploadItem(),
    );
  }

  uploadItem() {
    return Container(
        decoration: BoxDecoration(
            image: DecorationImage(
                fit: BoxFit.cover,
                image: NetworkImage(
                    'https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1573655792197&di=f9469fa087a082aedfd22514c1549e1f&imgtype=0&src=http%3A%2F%2Fimg8.zol.com.cn%2Fbbs%2Fupload%2F19571%2F19570481.jpg'))),
        padding: EdgeInsets.only(
            top: ScreenUtil.instance.setWidth(50),
            bottom: ScreenUtil.instance.setWidth(80),
            left: ScreenUtil.instance.setWidth(80),
            right: ScreenUtil.instance.setWidth(80)),
        alignment: Alignment.center,
        width: screenSize.width,
        height: double.maxFinite,
        child: InkWell(
            onTap: () {
              _model.scanImages(context);
            },
            child: Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.all(
                  //圆角
                  Radius.circular(20.0),
                ),
                border: Border.all(width: 1.0),
              ),
              alignment: Alignment.center,
              width: double.maxFinite,
              height: double.maxFinite,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  Container(
                      height: 25,
                      width: 100,
                      color: Colors.blueAccent,
                      child: FlatButton(
                        onPressed: () {
                          Navigator.push(context, CustomRoute(PicPage()));
                        },
                        child: baseText("跳过", 15, Colors.white),
                      )),
                  Expanded(
                    child: Container(
                    ),
                  ),
                  SvgPicture.asset("image/add.svg"),
                  Container(
                    margin: EdgeInsets.only(top: 30),
                    child: baseText("点击上传照片", 20, ALColors.ColorE4E4E4),
                  ),
                  Expanded(
                    child: Container(),
                  ),
                ],
              ),
            )));
  }
}
