/*
 * @author lsy
 * @date   2019-11-08
 **/
import 'dart:async';
import 'dart:io';
import 'dart:math';
import 'dart:ui' as ui;
import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:example_flutter/HomeModel/page/work/temp.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllTabBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/commonModel/util/ImageUtil.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/material.dart';
import 'package:flutter_animation_set/animator.dart';

class WorkModel extends BaseModel {
  LiveData<PointItem> pointLive = new LiveData();
  LiveData<List<int>> nowIndexLive = new LiveData();
  LiveData<Map<String, List<List<String>>>> selectLive = new LiveData();
  LiveData<Map<String, List<List<String>>>> tabLive = new LiveData();

  Map<String, List<List<String>>> selectMap = new Map();
  Map<String, List<List<String>>> fixDataMap = new Map();
  HomeRepo _repo = HomeRepo.getInstance();
  PointItem pointItem = new PointItem();

  AllTabBean allTabBean;
  int imageId;
  int currentIndex;

  WorkModel(this.imageId, this.currentIndex);

  getImageResutl(BuildContext context, bool showPicker) {
    if (showPicker) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中..."))
        ..show(context);
    }
    _repo.imageAi(imageId).listen((value) {
      selectMap.clear();
      List<List<String>> browList = new List();

      if (value.anno.browsStyle != null && value.anno.browsStyle != "无结果") {
        browList.add([EXPLAN["brows_style"], value.anno.browsStyle]);
      }

      if (value.anno.browsThickness != null &&
          value.anno.browsThickness != "无结果") {
        browList.add([EXPLAN["brows_thickness"], value.anno.browsThickness]);
      }

      if (value.anno.dense != null && value.anno.dense != "无结果") {
        browList.add([EXPLAN["Dense"], value.anno.dense]);
      }

      if (value.anno.browDensity != null && value.anno.browDensity != "无结果") {
        browList.add([EXPLAN["brow_density"], value.anno.browDensity]);
      }

      if (value.anno.browsSpacing != null && value.anno.browsSpacing != "无结果") {
        browList.add([EXPLAN["brows_spacing"], value.anno.browsSpacing]);
      }

      if (value.anno.browShape != null && value.anno.browShape != "无结果") {
        browList.add([EXPLAN["brow_shape"], value.anno.browShape]);
      }

      if (browList.isNotEmpty) {
        selectMap.putIfAbsent("眉毛部分", () => browList);
      }

      List<List<String>> eyeList = new List();

      if (value.anno.eyelidLeft != null && value.anno.eyelidLeft != "无结果") {
        eyeList.add([EXPLAN["eyelid_left"], value.anno.eyelidLeft]);
      }

      if (value.anno.eyelidRight != null && value.anno.eyelidRight != "无结果") {
        eyeList.add([EXPLAN["eyelid_right"], value.anno.eyelidRight]);
      }

      if (value.anno.eyeShapeRight != null &&
          value.anno.eyeShapeRight != "无结果") {
        eyeList.add([EXPLAN["eye_shape_right"], value.anno.eyeShapeRight]);
      }

      if (value.anno.eyeShapeLeft != null && value.anno.eyeShapeLeft != "无结果") {
        eyeList.add([EXPLAN["eye_shape_left"], value.anno.eyeShapeLeft]);
      }

      if (value.anno.pouch != null && value.anno.pouch != "无结果") {
        eyeList.add([EXPLAN["pouch"], value.anno.pouch]);
      }

      if (value.anno.eyeDistance != null && value.anno.eyeDistance != "无结果") {
        eyeList.add([EXPLAN["eye_distance"], value.anno.eyeDistance]);
      }
      if (eyeList.isNotEmpty) {
        selectMap.putIfAbsent("眼睛部分", () => eyeList);
      }

      List<List<String>> noseList = new List();
      if (value.anno.nose != null && value.anno.nose != "无结果") {
        noseList.add([EXPLAN["nose"], value.anno.nose]);
      }
      if (noseList.isNotEmpty) {
        selectMap.putIfAbsent("鼻子部分", () => noseList);
      }

      List<List<String>> lipList = new List();
      if (value.anno.lipThickness != null && value.anno.lipThickness != "无结果") {
        lipList.add([EXPLAN["lip_thickness"], value.anno.lipThickness]);
      }
      if (value.anno.lipPeak != null && value.anno.lipPeak != "无结果") {
        lipList.add([EXPLAN["lip_peak"], value.anno.lipPeak]);
      }
      if (value.anno.lipShape != null && value.anno.lipShape != "无结果") {
        lipList.add([EXPLAN["lip_shape"], value.anno.lipShape]);
      }

      if (value.anno.lipRadian != null && value.anno.lipRadian != "无结果") {
        lipList.add([EXPLAN["lip_radian"], value.anno.lipRadian]);
      }
      if (lipList.isNotEmpty) {
        selectMap.putIfAbsent("嘴唇部分", () => lipList);
      }

      List<List<String>> wrinkList = new List();
      if (value.anno.wrink != null && value.anno.wrink != "无结果") {
        wrinkList.add([EXPLAN["wrink"], value.anno.wrink]);
      }
      if (wrinkList.isNotEmpty) {
        selectMap.putIfAbsent("法令纹", () => wrinkList);
      }

      List<List<String>> cheekboneList = new List();
      if (value.anno.cheekbone != null && value.anno.cheekbone != "无结果") {
        cheekboneList.add([EXPLAN["cheekbone"], value.anno.cheekbone]);
      }
      if (cheekboneList.isNotEmpty) {
        selectMap.putIfAbsent("颧骨部分", () => cheekboneList);
      }

      List<List<String>> chinList = new List();
      if (value.anno.chinShape != null && value.anno.chinShape != "无结果") {
        chinList.add([EXPLAN["chin_shape"], value.anno.chinShape]);
      }
      if (chinList.isNotEmpty) {
        selectMap.putIfAbsent("下巴部分", () => chinList);
      }

      List<List<String>> faceList = new List();
      if (value.anno.face != null && value.anno.face != "无结果") {
        faceList.add([EXPLAN["face"], value.anno.face]);
      }
      if (faceList.isNotEmpty) {
        selectMap.putIfAbsent("脸型相关", () => faceList);
      }

      selectLive.notifyView(selectMap);
      if (showPicker) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Toast.show(context, "这个照片估计识别不出来 导致出错");
      if (showPicker) {
        Navigator.pop(context);
      }
    });
  }

  selectChangeToMap() {}

  allTab(BuildContext context, bool showPicker) {
    if (showPicker) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中"))
        ..show(context);
    }
    nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
    HomeRepo.getInstance().getAllTab().listen((value) {
      allTabBean = value;
      fixDataMap.clear();

      //=====眉毛
      List<List<String>> browList = new List();

      List<String> eyebrowStyle = new List();
      eyebrowStyle.add(allTabBean.eyebrowstyle.name);
      eyebrowStyle.add(allTabBean.eyebrowstyle.eyebrowstyleData.willow);
      eyebrowStyle.add(allTabBean.eyebrowstyle.eyebrowstyleData.wild);

      List<String> eyebrowthickStyle = new List();
      eyebrowthickStyle.add(allTabBean.eyebrowthickness.name);
      eyebrowthickStyle
          .add(allTabBean.eyebrowthickness.eyebrowthicknessData.cumei);
      eyebrowthickStyle
          .add(allTabBean.eyebrowthickness.eyebrowthicknessData.biaozhunmei);
      eyebrowthickStyle
          .add(allTabBean.eyebrowthickness.eyebrowthicknessData.xiemei);

      List<String> concen = new List();
      concen.add(allTabBean.eyebrowsconcentration.name);
      concen.add(
          allTabBean.eyebrowsconcentration.eyebrowsconcentrationData.piandan);
      concen.add(allTabBean
          .eyebrowsconcentration.eyebrowsconcentrationData.feichandan);
      concen.add(allTabBean
          .eyebrowsconcentration.eyebrowsconcentrationData.nongduzhenghao);

      List<String> concenf = new List();
      concenf.add(allTabBean.eyebrowsconcentrationF.name);
      concenf.add(allTabBean
          .eyebrowsconcentrationF.eyebrowsconcentrationFData.fenbujunyun);
      concenf.add(allTabBean
          .eyebrowsconcentrationF.eyebrowsconcentrationFData.qianshuhoumi);
      concenf.add(allTabBean
          .eyebrowsconcentrationF.eyebrowsconcentrationFData.qianmuhoushu);
      concenf.add(allTabBean
          .eyebrowsconcentrationF.eyebrowsconcentrationFData.lianjunyun);

      List<String> brow = new List();
      brow.add(allTabBean.brow.name);
      brow.add(allTabBean.brow.browData.wide);
      brow.add(allTabBean.brow.browData.narrow);
      brow.add(allTabBean.brow.browData.appropriate);

      List<String> eyebrow = new List();
      eyebrow.add(allTabBean.eyebow.name);
      eyebrow.add(allTabBean.eyebow.eyebowData.on);
      eyebrow.add(allTabBean.eyebow.eyebowData.standard);
      eyebrow.add(allTabBean.eyebow.eyebowData.one);
      eyebrow.add(allTabBean.eyebow.eyebowData.sagging);

      browList.add(eyebrowStyle);
      browList.add(eyebrowthickStyle);
      browList.add(concen);
      browList.add(concenf);
      browList.add(brow);
      browList.add(eyebrow);

      fixDataMap.putIfAbsent("眉毛部分", () => browList);

      //=====眼睛👀
      List<List<String>> eyeList = new List();

      List<String> lefteye = new List();
      lefteye.add(allTabBean.leftEye.name);
      lefteye.add(allTabBean.leftEye.leftEyeData.seye);
      lefteye.add(allTabBean.leftEye.leftEyeData.eyes);
      lefteye.add(allTabBean.leftEye.leftEyeData.doubleIn);

      List<String> righteye = new List();
      righteye.add(allTabBean.rigthEye.name);
      righteye.add(allTabBean.rigthEye.rigthEyeData.seye);
      righteye.add(allTabBean.rigthEye.rigthEyeData.eyes);
      righteye.add(allTabBean.rigthEye.rigthEyeData.doubleIn);

      List<String> eyebag = new List();
      eyebag.add(allTabBean.eyebag.name);
      eyebag.add(allTabBean.eyebag.eyebagData.yes);
      eyebag.add(allTabBean.eyebag.eyebagData.no);

      List<String> eyeStyleleft = new List();
      eyeStyleleft.add(allTabBean.eyestyleLeft.name);
      eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.almonEyes);
      eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.peach);
      eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.fineCheng);
      eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.deerEye);
      eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.dogEye);

      List<String> eyeStyleright = new List();
      eyeStyleright.add(allTabBean.eyestyleRight.name);
      eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.almonEyes);
      eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.peach);
      eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.fineCheng);
      eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.deerEye);
      eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.dogEye);

      List<String> eyeSpace = new List();
      eyeSpace.add(allTabBean.eyespacing.name);
      eyeSpace.add(allTabBean.eyespacing.eyespacingData.wide);
      eyeSpace.add(allTabBean.eyespacing.eyespacingData.narrow);
      eyeSpace.add(allTabBean.eyespacing.eyespacingData.appropriate);

      eyeList.add(lefteye);
      eyeList.add(righteye);
      eyeList.add(eyeStyleleft);
      eyeList.add(eyeStyleright);
      eyeList.add(eyebag);
      eyeList.add(eyeSpace);
      fixDataMap.putIfAbsent("眼睛部分", () => eyeList);

      //======== 鼻子👃
      List<List<String>> noseList = new List();

      List<String> nose = new List();
      nose.add(allTabBean.nose.name);
      nose.add(allTabBean.nose.noseData.narrowNose);
      nose.add(allTabBean.nose.noseData.standardNose);
      nose.add(allTabBean.nose.noseData.widepNose);
      nose.add(allTabBean.nose.noseData.wideNose);
      noseList.add(nose);
      fixDataMap.putIfAbsent("鼻子部分", () => noseList);

      //====== 嘴唇👄

      List<List<String>> mouthList = new List();

      List<String> mouth = new List();
      mouth.add(allTabBean.mouth.name);
      mouth.add(allTabBean.mouth.mouthData.standard);
      mouth.add(allTabBean.mouth.mouthData.thick);
      mouth.add(allTabBean.mouth.mouthData.thin);

      List<String> lip = new List();
      lip.add(allTabBean.lip.name);
      lip.add(allTabBean.lip.lipData.yes);
      lip.add(allTabBean.lip.lipData.no);
      lip.add(allTabBean.lip.lipData.notObvious);

      List<String> lipscurved = new List();
      lipscurved.add(allTabBean.lipscurved.name);
      lipscurved.add(allTabBean.lipscurved.lipscurvedData.smile);
      lipscurved.add(allTabBean.lipscurved.lipscurvedData.moderate);
      lipscurved.add(allTabBean.lipscurved.lipscurvedData.attitude);

      List<String> Speciallip = new List();
      Speciallip.add(allTabBean.speciallip.name);
      Speciallip.add(allTabBean.speciallip.speciallipData.cherryLip);
      Speciallip.add(allTabBean.speciallip.speciallipData.supermodelLip);

      mouthList.add(mouth);
      mouthList.add(lip);
      mouthList.add(lipscurved);
      mouthList.add(Speciallip);
      fixDataMap.putIfAbsent("嘴唇部分", () => mouthList);

      //=======其他
      List<List<String>> wrinkList = new List();

      List<String> wrink = new List();
      wrink.add(allTabBean.wrink.name);
      wrink.add(allTabBean.wrink.wrinkData.yes);
      wrink.add(allTabBean.wrink.wrinkData.no);

      wrinkList.add(wrink);
      fixDataMap.putIfAbsent("法令纹", () => wrinkList);

      List<List<String>> checkboneList = new List();

      List<String> checkbone = new List();
      checkbone.add(allTabBean.checkbone.name);
      checkbone.add(allTabBean.checkbone.checkboneData.high);
      checkbone.add(allTabBean.checkbone.checkboneData.flat);
      checkboneList.add(checkbone);
      fixDataMap.putIfAbsent("颧骨部分", () => checkboneList);

      List<List<String>> chinList = new List();
      List<String> chin = new List();
      chin.add(allTabBean.chin.name);
      chin.add(allTabBean.chin.chinData.tip);
      chin.add(allTabBean.chin.chinData.party);
      chin.add(allTabBean.chin.chinData.round);
      chin.add(allTabBean.chin.chinData.ass);
      chinList.add(chin);
      fixDataMap.putIfAbsent("下巴部分", () => chinList);

      List<List<String>> faceList = new List();
      List<String> face = new List();
      face.add(allTabBean.face.name);
      face.add(allTabBean.face.faceData.babyFace);
      face.add(allTabBean.face.faceData.guazilian);
      face.add(allTabBean.face.faceData.fanglian);
      face.add(allTabBean.face.faceData.edanlian);
      face.add(allTabBean.face.faceData.changxinglian);
      face.add(allTabBean.face.faceData.lixinglian);
      face.add(allTabBean.face.faceData.jingzhuan);
      faceList.add(face);
      fixDataMap.putIfAbsent("脸型相关", () => faceList);

      tabLive.notifyView(fixDataMap);
      if (showPicker) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      if (showPicker) {
        Navigator.pop(context);
      }
    });
  }

  @override
  void dispose() {
    pointLive.dispost();
    nowIndexLive.dispost();
    tabLive.dispost();
    selectLive.dispost();
  }

  void selectItem(String key, String title, String result) {
    List<List<String>> innlist = selectMap[key];
    if (innlist == null || innlist.isEmpty) {
      selectMap[key] = [
        [title, result]
      ];
    } else {
      int index = -1;
      for (int i = 0; i < innlist.length; i++) {
        if (innlist[i][0] == title) {
          index = i;
          break;
        }
      }
      if (index != -1) {
        innlist[index][1] = result;
      } else {
        List<String> list = [title, result];
        innlist.add(list);
      }
    }
    selectLive.notifyView(selectMap);
  }

  void deleteSelectItem(BuildContext context, String key, String title) {
    BaseCenterPicker()
      ..setPicker(SurePicker("确定删除这个条目吗？", () {
        Navigator.pop(context);
      }, () {
        Navigator.pop(context);
        var selectList = selectMap[key];
        if (selectList != null && selectList.isNotEmpty) {
          if (selectList.length == 1) {
            selectMap.remove(key);
          } else {
            int index = -1;
            for (int i = 0; i < selectList.length; i++) {
              if (selectList[i][0] == title) {
                index = i;
              }
            }
            if (index != -1) {
              selectList.removeAt(index);
            }
          }
        }
        selectLive.notifyView(selectMap);
      }))
      ..show(context);
  }

  void imageNext(BuildContext context) {
    if (currentIndex == 8) {
      _repo.getImageResult(_repo.currentPage + 1, 9).listen((data) {
        if (data == null || data.picList == null || data.picList.isEmpty) {
          Toast.show(context, "已经是最后一张了哦～");
        } else {
          currentIndex = 0;
          _repo.currentPage = _repo.currentPage + 1;
          _repo.updateCurrentPageList(data.picList);
          getNetWorkImg(context);
          imageId = _repo.getCurrentPageList()[currentIndex].id;
          nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
          selectLive.notifyView(null);
          getImageResutl(context, false);
        }
      }).onError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
      });
    } else {
      if (currentIndex + 1 > _repo.getCurrentPageList().length - 1) {
        Toast.show(context, "已经是最后一张了哦～");
        return;
      }
      currentIndex = currentIndex + 1;
      getNetWorkImg(context);
      imageId = _repo.getCurrentPageList()[currentIndex].id;
      selectLive.notifyView(null);
      getImageResutl(context, false);
      nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
    }
  }

  void imageBefore(BuildContext context) {
    if (currentIndex == 0) {
      if (_repo.currentPage == 1) {
        Toast.show(context, "已经是第一张了哦～");
        return;
      }
      _repo.currentPage = _repo.currentPage - 1;
      _repo.getImageResult(_repo.currentPage, 9).listen((data) {
        currentIndex = 8;
        _repo.updateCurrentPageList(data.picList);
        getNetWorkImg(context);
        imageId = _repo.getCurrentPageList()[currentIndex].id;
        selectLive.notifyView(null);
        getImageResutl(context, false);
        nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
      }).onError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
      });
    } else {
      currentIndex = currentIndex - 1;
      getNetWorkImg(context);
      imageId = _repo.getCurrentPageList()[currentIndex].id;
      selectLive.notifyView(null);
      getImageResutl(context, false);
      nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
    }
  }

  void save(BuildContext context, bool param1) {
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("保存中..."))
      ..show(context);
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.write("""
    {"face_details":{
    """);
    List<List<String>> finalResult = new List();
    selectMap.forEach((key, value) {
      for (int i = 0; i < value.length; i++) {
        String before;
        EXPLAN.forEach((k, v) {
          if (v == value[i][0]) {
            before = k;
          }
        });
        finalResult.add([before, value[i][1]]);
      }
    });
    for (int i = 0; i < finalResult.length; i++) {
      stringBuffer.write("""
        "${finalResult[i][0]}":"${finalResult[i][1]}"
      """);
      if (i != finalResult.length - 1) {
        stringBuffer.write(",");
      }
    }
    stringBuffer.write("}}");
    print("====>  ${stringBuffer.toString()}");
    _repo.saveImageResult(imageId, stringBuffer.toString()).listen((value) {
      if (value != null) {
        Navigator.pop(context);
        Navigator.pop(context, -1);
        Toast.show(context, "保存成功");
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Navigator.pop(context);
    });
  }

  void saveImage(BuildContext context) {
    Toast.show(context, "开始保存图片");
    getTempDir().then((value) {
      if (value != null) {
        print(value);
        DioUtil().getDio().download(_repo.getCurrentPageList()[currentIndex].picurl,
            "${value}/${DateTime.now().millisecondsSinceEpoch}.jpeg",
            onReceiveProgress: (int count, int total) {
          //进度
//          Toast.show(context, "进度！！ $count $total");
          print("进度！！ $count $total");
        }).then((value) {
          Toast.show(context, "下载完成");
          print("OKKK  ");
          openCachce();
        }).catchError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      }
    });
  }

  void syncPos(double dx, double dy) {
    pointItem.setX(dx);
    pointItem.setY(dy);
    pointLive.notifyView(pointItem);
  }

  void getNetWorkImg(BuildContext context) {
    loadNetWorkImage(_repo.getCurrentPageList()[currentIndex].picurl).then((value) {
      pointItem.reset();
      pointItem.setImage(value);
      pointLive.notifyView(pointItem);
    }).catchError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
    });
  }

  void syncPoint() {
    pointLive.notifyView(pointItem);
  }
}

class SurePicker implements ICenterPicker {
  VoidCallback cancel;
  VoidCallback sure;
  final String showText;

  SurePicker(this.showText, this.cancel, this.sure);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.all(Radius.circular(20))),
      width: 350,
      height: 260,
      child: Column(
        children: <Widget>[
          Expanded(
            child: Container(
              alignment: Alignment.center,
              child: baseText(showText, 15, Colors.black),
            ),
          ),
          Container(
            height: 1,
            width: double.maxFinite,
            color: Colors.black54,
          ),
          Container(
            width: double.maxFinite,
            height: 50,
            child: Row(
              children: <Widget>[
                Expanded(
                  child: GestureDetector(
                      onTap: cancel,
                      child: Container(
                        color: Colors.transparent,
                        alignment: Alignment.center,
                        child: baseText("取消", 12, Colors.black38),
                      )),
                ),
                Container(
                  width: 1,
                  height: double.maxFinite,
                  color: Colors.black54,
                ),
                Expanded(
                  child: GestureDetector(
                    onTap: sure,
                    child: Container(
                      color: Colors.transparent,
                      alignment: Alignment.center,
                      child: baseText("确定", 12, Colors.red),
                    ),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
