/*
 * @author lsy
 * @date   2019-11-15
 **/
class ImageAiBean {
  String url;
  Anno anno;

  ImageAiBean({this.url, this.anno});

  ImageAiBean.fromJson(Map<String, dynamic> json) {
    url = json['url'];
    anno = json['anno'] != null ? new Anno.fromJson(json['anno']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['url'] = this.url;
    if (this.anno != null) {
      data['anno'] = this.anno.toJson();
    }
    return data;
  }
}

class Anno {
  String browShape;
  String browsStyle;
  String browsSpacing;
  String browsThickness;
  String dense;
  String browDensity;
  String face;
  String pouch;
  String eyelidLeft;
  String eyelidRight;
  String eyeShapeLeft;
  String eyeShapeRight;
  String eyeDistance;
  String cheekbone;
  String chinShape;
  String wrink;
  String nose;
  String lipThickness;
  String lipRadian;
  String lipShape;
  String lipPeak;

  Anno(
      {this.browShape,
        this.browsStyle,
        this.browsSpacing,
        this.browsThickness,
        this.dense,
        this.browDensity,
        this.face,
        this.pouch,
        this.eyelidLeft,
        this.eyelidRight,
        this.eyeShapeLeft,
        this.eyeShapeRight,
        this.eyeDistance,
        this.cheekbone,
        this.chinShape,
        this.wrink,
        this.nose,
        this.lipThickness,
        this.lipRadian,
        this.lipShape,
        this.lipPeak});

  Anno.fromJson(Map<String, dynamic> json) {
    browShape = json['brow_shape'];
    browsStyle = json['brows_style'];
    browsSpacing = json['brows_spacing'];
    browsThickness = json['brows_thickness'];
    dense = json['Dense'];
    browDensity = json['brow_density'];
    face = json['face'];
    pouch = json['pouch'];
    eyelidLeft = json['eyelid_left'];
    eyelidRight = json['eyelid_right'];
    eyeShapeLeft = json['eye_shape_left'];
    eyeShapeRight = json['eye_shape_right'];
    eyeDistance = json['eye_distance'];
    cheekbone = json['cheekbone'];
    chinShape = json['chin_shape'];
    wrink = json['wrink'];
    nose = json['nose'];
    lipThickness = json['lip_thickness'];
    lipRadian = json['lip_radian'];
    lipShape = json['lip_shape'];
    lipPeak = json['lip_peak'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['brow_shape'] = this.browShape;
    data['brows_style'] = this.browsStyle;
    data['brows_spacing'] = this.browsSpacing;
    data['brows_thickness'] = this.browsThickness;
    data['Dense'] = this.dense;
    data['brow_density'] = this.browDensity;
    data['face'] = this.face;
    data['pouch'] = this.pouch;
    data['eyelid_left'] = this.eyelidLeft;
    data['eyelid_right'] = this.eyelidRight;
    data['eye_shape_left'] = this.eyeShapeLeft;
    data['eye_shape_right'] = this.eyeShapeRight;
    data['eye_distance'] = this.eyeDistance;
    data['cheekbone'] = this.cheekbone;
    data['chin_shape'] = this.chinShape;
    data['wrink'] = this.wrink;
    data['nose'] = this.nose;
    data['lip_thickness'] = this.lipThickness;
    data['lip_radian'] = this.lipRadian;
    data['lip_shape'] = this.lipShape;
    data['lip_peak'] = this.lipPeak;
    return data;
  }
}



