/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:convert';
import 'dart:io';

import 'package:example_flutter/UserModel/service/remote/api/UserApi.serv.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserBean.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserToken.dart';
import 'package:rxdart/rxdart.dart';

class Resp {
  static Resp _resp;

  Resp._();

  static Resp getInstance() {
    if (_resp == null) {
      _resp = Resp._();
    }
    return _resp;
  }

  Observable<UserToken> login(String userName, String userWord) {
    return UserApiImpl().login(userName, userWord);
  }

  Observable<UserBean> resign(String userName, String userWord) {
    return UserApiImpl().resign(userName, userWord);
  }
}
