/*
 * @author lsy
 * @date   2019-11-07
 **/

import 'package:example_flutter/Annotations/anno/Get.dart';
import 'package:example_flutter/Annotations/anno/Post.dart';
import 'package:example_flutter/Annotations/anno/Query.dart';
import 'package:example_flutter/Annotations/anno/ServiceCenter.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserBean.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserInfoBean.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserToken.dart';

@ServiceCenter()
abstract class UserApi {
  @Post("api-token-auth/")
  UserToken login(
      @Query("username") String userName, @Query("password") String password);

  @Post("users/")
  UserBean resign(
      @Query("username") String userName, @Query("password") String password);

  @Get("userinfo/")
  UserInfoBean getUserInfo();
}
