/*
 * @author lsy
 * @date   2019-09-16
 **/

import 'dart:math';

import 'package:dio/dio.dart';
import 'package:example_flutter/commonModel/net/DioUtil.dart';

/**
 * 生产环境
 */
const String APP_HOST_RELEASE = "https://earth.iyanzhi.com";
/**
 * 测试环境
 */
const String APP_HOST_DEBUG = "http://earth.gmapp.env";

/**
 * 开发环境
 */
const String APP_HOST_DEV = "http://earth.alpha.newdev";

class Api {
  static String BUILD_CONFIG;
  static String PROVIDER_NAME;

  static Api intance = new Api._();

  Api._();

  static Api getInstance() {
    return intance;
  }

  bool initBuildConfig(Map params) {
    if (params == null) {
      return false;
    }
    String buildConfig = params["buildConfig"];
    if (buildConfig == null) {
      return false;
    }
    BUILD_CONFIG = buildConfig;
    PROVIDER_NAME = params["provider"];
    String baseUrl = getBaseUrl(buildConfig) + "/";
    if (baseUrl == null) {
      return false;
    }
    if (buildConfig == "debug" || buildConfig == "dev") {
      String httpProxy = params["proxy"];
      if (httpProxy != null && httpProxy.isNotEmpty) {
        print("PROXY --> $httpProxy");
        DioUtil().setProxy(httpProxy);
      }
    }
    print("baseUrl --> $baseUrl");
    DioUtil().setConfig(HttpConfig(
        options: BaseOptions(
          baseUrl: baseUrl,
        ),
        nativeCookie: {"Cookie": params["Cookie"]}));
    return true;
  }

  bool setDioCookie(Map params) {
    if (params == null) {
      return false;
    }
    var cookie = params["cookie"] == null ? params["Cookie"] : params["cookie"];
    if (cookie == null) {
      return false;
    }
    DioUtil().setCookie(cookie);
    return true;
  }

  String getBaseUrl(String string) {
    if (string == "debug") {
      return APP_HOST_DEBUG;
    } else if (string == "dev") {
      return APP_HOST_DEV;
    } else if (string == "release") {
      return APP_HOST_RELEASE;
    } else {
      return null;
    }
  }
}
