/*
 * @author lsy
 * @date   2019-11-22
 **/
import 'dart:async';
import 'dart:ui';

import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:flutter/material.dart';
import 'dart:ui' as ui;

import 'package:flutter_animation_set/animator.dart';

class WorkView extends CustomPainter {
  PointItem item;
  Function(double value, double topBuf, double topAdd) call;
  Path path;

  WorkView(this.item, this.call) {}
  Paint ImagePaint = new Paint()..isAntiAlias = true;
  Paint linePaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.black
    ..strokeWidth = 1;

  Paint pointPaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.red
    ..strokeWidth = 1;

  Paint pathPaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.black38
    ..style = PaintingStyle.fill;

  Paint circlePaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.redAccent
    ..style = PaintingStyle.fill;

  Paint rectPaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.blue
    ..style = PaintingStyle.stroke
    ..strokeWidth = 2;

  @override
  void paint(Canvas canvas, Size size) {
    if (item.scareSize != 1) {
      canvas.scale(item.scareSize, item.scareSize);
    }
    if (item.tranX != 0 || item.tranY != 0) {
      if (item.tranX + size.width / item.scareSize > size.width) {
        item.tranX = size.width - size.width / item.scareSize;
      }
      if (item.tranY + size.height / item.scareSize > size.height) {
        item.tranY = size.height - size.height / item.scareSize;
      }
      canvas.translate(-item.tranX, -item.tranY);
    }

    if (item.getImage() != null) {
      double scareSize = item.getImage().width / size.width;
      double showWidth = size.width;
      double showheight = item.getImage().height / scareSize;
      double top;
      if (showheight > size.height) {
//        showheight = size.height;
//        top=(showheight-size.height)/2;
      } else {

      }
      top = (size.height - showheight) / 2;
      call(scareSize, top, (size.height - showheight) / 2);
      canvas.drawImageRect(
          item.getImage(),
          Rect.fromLTWH(0.0, 0.0, item.getImage().width.toDouble(),
              item.getImage().height.toDouble()),
          Rect.fromLTWH(0, top, showWidth, showheight),
          ImagePaint);
    }
//    double newX = (item.getX() + item.getTranX()) / item.scareSize;
    double newX = (item.getX() / item.scareSize + item.getTranX());

//    double newY = (item.getY() + item.getTranY()) / item.scareSize;
    double newY = (item.getY() / item.scareSize + item.getTranY());
    if (item.getX() != null &&
        item.getY() != null &&
        item.getX() >= 0 &&
        item.getY() >= 0) {
      canvas.drawLine(Offset(newX, 0), Offset(newX, size.height), linePaint);
      canvas.drawLine(Offset(0, newY), Offset(size.width, newY), linePaint);
      TextPainter(
          text: TextSpan(
              text: "${newX.toInt()},${newY.toInt()}",
              style: TextStyle(
                  fontSize: 15,
                  color: Colors.yellow,
                  fontWeight: FontWeight.w300)),
          textDirection: TextDirection.ltr,
          textAlign: TextAlign.center)
        ..layout(maxWidth: 150, minWidth: 30)
        ..paint(canvas, Offset(newX + 5, newY - 20));
    }
    if (item.rectModel) {
      canvas.drawRect(item.rect, rectPaint);
      canvas.drawRect(item.rect, pathPaint);
      canvas.drawCircle(Offset(item.rect.left, item.rect.top), 5, circlePaint);
      canvas.drawCircle(
          Offset(item.rect.right, item.rect.bottom), 5, circlePaint);
    } else {
      if (item.getPoints().isNotEmpty) {
        canvas.drawPoints(PointMode.polygon, item.getPoints(), pointPaint);
      }
      if (item.drawPath) {
        if (item.getPoints().length < 2) {
          return;
        }
        path = new Path();
        path.moveTo(item.getPoints()[0].dx, item.getPoints()[0].dy);
        for (int i = 0; i < item.getPoints().length; i++) {
          path.lineTo(item.getPoints()[i].dx, item.getPoints()[i].dy);
        }
        path.close();
        canvas.drawPath(path, pathPaint);
      }
    }
  }

  bool calutePath(Offset offset) {
    if (path != null) {
      return path.contains(offset);
    }
    return false;
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) {
    return true;
  }
}
