/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:async';
import 'dart:convert';
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:example_flutter/HomeModel/page/picture/PicPage.dart';
import 'package:example_flutter/HomeModel/page/work/WorkPage.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllProjectBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/anim/Anim.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/src/widgets/framework.dart';
import 'package:file_chooser/file_chooser.dart';
import 'package:rxdart/rxdart.dart';

import 'UploadBean.dart';

class HomeModel extends BaseModel {
  HomeRepo repo = HomeRepo.getInstance();
  List<UploadResultBean> scanList = new List();
  int allSize;
  int nowSize;
  List<String> uploadFile = new List();
  LiveData<List<UploadItem>> uploadLive = new LiveData();
  bool uploading = false;


  @override
  void dispose() {
    uploadLive.dispost();
  }

  init() {
    uploading = false;
//    allprojectLive.notifyView(AllProjectBean("w"));
  }

  void scanImages(BuildContext context) async {
    if (uploading) {
      Toast.show(context, "客观稍等 这波图片还没传输完");
      return;
    }
    await showOpenPanel((result, files) {
      if (result != FileChooserResult.ok || files.isEmpty) {
        Toast.show(context, "没有选择文件 批量上传 可以按住shift 或者拖拽鼠标！");
        return;
      }
      uploading = true;
      List<UploadItem> items = new List();
      files.forEach((value) {
        items.add(new UploadItem()..path = value);
      });
      uploadLive.notifyView(items);
      allSize = files.length;
      nowSize = 0;
      scanList.clear();
      uploadFile.clear();
      uploadFile.addAll(files);
      uploadImage(context, uploadFile[nowSize]);
    }, allowsMultipleSelection: true);
  }

  void uploadImage(
    BuildContext context,
    String path,
  ) {
    HomeRepo.getInstance().uploadImg(path).listen((value) {
      if (value != null) {
        print(value.id);
        HomeRepo.getInstance().detectImg(value.id).listen((value) {
          if (value != null) {
            if (value.isEffective) {
              uploadItem(context, true, null);
            } else {
              uploadItem(
                  context,
                  false,
                  value.msg == null && value.msg.isEmpty
                      ? "这个图片不符合标准哦～"
                      : value.msg);
            }
          } else {
            uploadItem(context, false, "图片检测出错!");
          }
        }).onError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
          uploadItem(context, false, "图片检测出错!");
        });
      } else {
        uploadItem(context, false, "上传图片失败!");
      }
    }).onError((erro) {
      Toast.show(context, erro.toString());
      print(erro.toString());
      uploadItem(context, false, "上传图片失败!");
    });
  }

  uploadItem(BuildContext context, bool success, String reason) {
    uploadLive.data[nowSize].reason = reason;
    if (success) {
      uploadLive.data[nowSize].state = 1;
    } else {
      uploadLive.data[nowSize].state = 2;
    }
    uploadLive.notifyView(uploadLive.data);
    nowSize++;
    if (nowSize < allSize) {
      uploadImage(context, uploadFile[nowSize]);
    } else {
      uploading = false;
    }
  }

  void success(BuildContext buildContext) {
    Navigator.push(buildContext, CustomRoute(PicPage()));
  }
}

UploadResultBean uploadImg(String value) {
  return UploadResultBean.fromJson(json.decode(value));
}
