/*
 * @author lsy
 * @date   2019-10-21
 **/
import 'package:flutter/material.dart';
import 'package:flutter/src/widgets/framework.dart';
import 'package:flutter_animation_set/widget/transition_animations.dart';

import 'BaseCenterPicker.dart';

class BaseLoadingItem implements ICenterPicker {
  final String loadingText;

  BaseLoadingItem(this.loadingText);

  @override
  Widget build(BuildContext context) {
    return new Container(
      width: 120.0,
      height: 120.0,
      child: new Container(
        ///弹框背景和圆角
        decoration: BoxDecoration(
//          color: Colors.orange,
          color: Colors.purple,
          gradient: LinearGradient(colors: [
            Color.fromARGB(255, 253, 113, 34),
            Color.fromARGB(255, 253, 166, 41)
          ], begin: Alignment.centerRight, end: Alignment.centerLeft),
          borderRadius: BorderRadius.circular(8),
        ),
        child: new Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            new YYWanderingCubes(),
            new Padding(
              padding: const EdgeInsets.only(
                top: 20.0,
              ),
              child: new Text(
                loadingText,
                style: new TextStyle(fontSize: 16.0, color: Colors.white),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
