package com.example.myimagepicker.config

import android.text.TextUtils
import com.example.gengmei_flutter_plugin.utils.ImageLoader
import java.util.ArrayList

/**
 * Created by lsy
 * on 2019/3/27
 */
class ConfigManager private constructor() {

    var title: String? = null//标题
    var selectColor: Int? = 0

    var isShowCamera: Boolean = false//是否显示拍照Item，默认不显示
    var isShowImage = true//是否显示图片，默认显示
    var isShowVideo = true//是否显示视频，默认显示
    var selectionMode = SELECT_MODE_SINGLE//选择模式，默认单选
    var maxCount = 1
        set(maxCount) {
            if (maxCount > 1) {
                selectionMode = SELECT_MODE_MULTI
            }
            field = maxCount
        }//最大选择数量，默认为1

    var imageLoader: ImageLoader? = null
        @Throws(Exception::class)
        get() {
            if (field == null) {
                throw Exception("imageLoader is null")
            }
            return field
        }

    companion object {

        val SELECT_MODE_SINGLE = 0
        val SELECT_MODE_MULTI = 1

        @Volatile
        private var mConfigManager: ConfigManager? = null

        val instance: ConfigManager
            get() {
                if (mConfigManager == null) {
                    synchronized(ConfigManager::class.java) {
                        if (mConfigManager == null) {
                            mConfigManager = ConfigManager()
                        }
                    }
                }
                return mConfigManager!!
            }
    }
}