package com.example.myimagepicker.repository.local

import android.content.Context
import android.database.Cursor
import android.net.Uri
import android.provider.MediaStore
import android.util.Log
import java.io.File
import java.util.ArrayList

/**
 * Created by lsy
 * on 2019/3/27
 */
abstract class AbsMediaScanner<T>(private val mContext: Context) {

    private val filter: Int = 5000
    /**
     * 查询URI
     *
     * @return
     */
    protected abstract val scanUri: Uri

    /**
     * 查询列名
     *
     * @return
     */
    protected abstract val projection: Array<String>

    /**
     * 查询条件
     *
     * @return
     */
    protected abstract val selection: String

    /**
     * 查询条件值
     *
     * @return
     */
    protected abstract val selectionArgs: Array<String>?

    /**
     * 查询排序
     *
     * @return
     */
    protected abstract val order: String

    /**
     * 对外暴露游标，让开发者灵活构建对象
     *
     * @param cursor
     * @return
     */
    protected abstract fun parse(cursor: Cursor): T

    /**
     * 根据查询条件进行媒体库查询，隐藏查询细节，让开发者更专注业务
     *
     * @return
     */
    fun queryMedia(): ArrayList<T> {
        val list = ArrayList<T>()
        val contentResolver = mContext.contentResolver
        val cursor = contentResolver.query(scanUri, projection, selection, selectionArgs, order)
        if (cursor != null && cursor.moveToFirst()) {
            if (cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.SIZE)) >= filter) {
                val path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATA))
                if(File(path).exists()){
                    val t = parse(cursor)
                    list.add(t)
                }
            }
            while (cursor.moveToNext()) {
                if (cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.SIZE)) >= filter) {
                    val path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATA))
                    if(File(path).exists()){
                        val t = parse(cursor)
                        list.add(t)
                    }
                }
            }
            cursor.close()
        }
        return list
    }

}