package com.example.gengmei_flutter_plugin.result

import android.util.Log
import android.util.SparseArray
import io.flutter.plugin.common.MethodChannel

/**
 * @author lsy
 * @date   2019-09-25
 */
class ResultManager private constructor() {
    val map = HashMap<Long, MethodChannel.Result>();

    init {

    }

    fun addResult(key: Long, result: MethodChannel.Result) {
        map.put(key, result)
    }

    fun resultSuccess(key: Long, value: Any) {
        Log.e("lsy","KEYYY $key  ")
        map.get(key)?.run {
            this.success(value);
        }
        map.remove(key)
        Log.e("lsy"," ${map.size}")
    }

    fun resultError(key: Long, message: String, ob: Any) {
        map.get(key)?.run {
            this.error(message, message, ob)
        }
        map.remove(key)
        Log.e("lsy"," ${map.size}")
    }


    companion object {

        private val instance = ResultManager();

        @JvmStatic
        fun getInstance(): ResultManager {
            return instance;
        }
    }
}