package com.example.gengmei_flutter_plugin.sharedPrefernces

import android.app.Application
import android.content.Context
import android.content.SharedPreferences
import com.example.gengmei_flutter_plugin.ex.RxExpecition
import io.reactivex.Observable
import io.reactivex.ObservableOnSubscribe
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * @author lsy
 * @date   2019-09-25
 */
class SharedManager private constructor(app: Context) {

    private val preferences: SharedPreferences

    init {
        preferences = app.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE);
    }

    companion object {
        const val SHARED_PREFERENCES_NAME = "FlutterSharedPreferences"
        @Volatile
        private var instance: SharedManager?=null;

        @JvmStatic
        fun getInstance(app: Context): SharedManager {
            if (instance == null) {
                synchronized(this) {
                    if (instance == null) {
                        instance = SharedManager(app);
                    }
                }
            }
            return instance!!
        }
    }

    fun saveInt(key: String, value: Int): Observable<Boolean> {
        return Observable.create(ObservableOnSubscribe<Boolean> {
            it.onNext(preferences.edit().putInt(key, value).commit())
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun saveString(key: String, value: String): Observable<Boolean> {
        return Observable.create(ObservableOnSubscribe<Boolean> {
            it.onNext(preferences.edit().putString(key, value).commit())
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun saveBoolean(key: String, value: Boolean): Observable<Boolean> {
        return Observable.create(ObservableOnSubscribe<Boolean> {
            it.onNext(preferences.edit().putBoolean(key, value).commit())
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun saveFloat(key: String, value: Float): Observable<Boolean> {
        return Observable.create(ObservableOnSubscribe<Boolean> {
            it.onNext(preferences.edit().putFloat(key, value).commit())
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun saveStringList(key: String, value: Set<String>): Observable<Boolean> {
        return Observable.create(ObservableOnSubscribe<Boolean> {
            it.onNext(preferences.edit().putStringSet(key, value).commit())
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun getInt(key: String, value: Int): Observable<Int> {
        return Observable.create(ObservableOnSubscribe<Int> {
            it.onNext(preferences.getInt(key, value))
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun getString(key: String, value: String?): Observable<String?> {
        return Observable.create(ObservableOnSubscribe<String> {
            val string = preferences.getString(key, value)
            if(string==null){
                it.onNext("")
            }else{
                it.onNext(string)
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun getFloat(key: String, value: Float): Observable<Float> {
        return Observable.create(ObservableOnSubscribe<Float> {
            it.onNext(preferences.getFloat(key, value))
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }


    fun getBoolean(key: String, value: Boolean): Observable<Boolean> {
        return Observable.create(ObservableOnSubscribe<Boolean> {
            it.onNext(preferences.getBoolean(key, value))
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    fun getStringList(key: String, value: Set<String>?): Observable<ArrayList<String>> {
        return Observable.create(ObservableOnSubscribe<ArrayList<String>> {
            val stringSet = preferences.getStringSet(key, value)
            if(stringSet==null){
                throw RxExpecition("NULL!!")
            }
            val temp=ArrayList<String>()
            temp.addAll(stringSet)
            it.onNext(temp)
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

}