/*
 * @author lsy
 * @date   2019-09-25
 **/
import 'package:flutter/services.dart';

const String SAVE_STRING_SHARED = "SAVE_STRING_SHARED";
const String SAVE_INT_SHARED = "SAVE_INT_SHARED";
const String SAVE_FLOAT_SHARED = "SAVE_FLOAT_SHARED";
const String SAVE_BOOLEAN_SHARED = "SAVE_BOOLEAN_SHARED";
const String SAVE_STRINGLIST_SHARED = "SAVE_STRINGLIST_SHARED";

const String GET_STRING_SHARED = "GET_STRING_SHARED";
const String GET_INT_SHARED = "GET_INT_SHARED";
const String GET_FLOAT_SHARED = "GET_FLOAT_SHARED";
const String GET_BOOLEAN_SHARED = "GET_BOOLEAN_SHARED";
const String GET_STRINGLIST_SHARED = "GET_STRINGLIST_SHARED";

class SharedPlugin {
  static Future<bool> saveString(
      String key, String value, MethodChannel channel) async {
    return await channel
        .invokeMethod(SAVE_STRING_SHARED, {"key": key, "value": value});
  }

  static Future<bool> saveInt(
      String key, int value, MethodChannel channel) async {
    return await channel
        .invokeMethod(SAVE_INT_SHARED, {"key": key, "value": value});
  }

  static Future<bool> saveDouble(
      String key, double value, MethodChannel channel) async {
    return await channel
        .invokeMethod(SAVE_FLOAT_SHARED, {"key": key, "value": value});
  }

  static Future<bool> saveBoolean(
      String key, bool value, MethodChannel channel) async {
    return await channel
        .invokeMethod(SAVE_BOOLEAN_SHARED, {"key": key, "value": value});
  }

  static Future<bool> saveStringList(
      String key, List<String> value, MethodChannel channel) async {
    return await channel
        .invokeMethod(SAVE_STRINGLIST_SHARED, {"key": key, "value": value});
  }

  static Future<String> getString(
      String key, String value, MethodChannel channel) async {
    return await channel
        .invokeMethod(GET_STRING_SHARED, {"key": key, "value": value});
  }

  static Future<int> getInt(
      String key, int value, MethodChannel channel) async {
    return await channel
        .invokeMethod(GET_INT_SHARED, {"key": key, "value": value});
  }

  static Future<double> getDouble(
      String key, double value, MethodChannel channel) async {
    return await channel
        .invokeMethod(GET_FLOAT_SHARED, {"key": key, "value": value});
  }

  static Future<bool> getBoolean(
      String key, bool value, MethodChannel channel) async {
    return await channel
        .invokeMethod(GET_BOOLEAN_SHARED, {"key": key, "value": value});
  }

  static Future<List<String>> getStringList(
      String key, List<String> value, MethodChannel channel) async {
    List list = await channel
        .invokeMethod(GET_STRINGLIST_SHARED, {"key": key, "value": value});
    if(list==null){
      print("LIST IS NULLL!!!!  ");
      return Future.value(null);
    }
    List<String> finalList = [];
    list.forEach((value) {
      String temp = value as String;
      finalList.add(temp);
    });
    return Future.value(finalList);
  }
}
