package com.example.myimagepicker.repository

import android.content.Context
import android.graphics.BitmapFactory
import android.os.Environment
import android.provider.MediaStore
import android.util.Log
import com.example.gengmei_flutter_plugin.ImagePlugin.repository.local.ThumbUtil
import com.example.gengmei_flutter_plugin.utils.MyUtil
import com.example.gengmei_flutter_plugin.utils.MyUtil.Companion.getFileFullName
import com.example.gengmei_flutter_plugin.utils.MyUtil.Companion.getFileName
import com.example.gengmei_flutter_plugin.utils.MyUtil.Companion.getImageCacheDir
import com.example.myimagepicker.bean.MediaFile
import com.example.myimagepicker.bean.MediaFolder
import com.example.myimagepicker.luban.Luban
import com.example.myimagepicker.repository.local.ImageScanner
import com.example.myimagepicker.repository.local.VideoScanner
import io.reactivex.Observable
import io.reactivex.ObservableOnSubscribe
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.schedulers.Schedulers
import java.io.File
import java.util.*
import java.util.concurrent.*
import kotlin.collections.ArrayList
import kotlin.collections.HashMap
import android.media.ThumbnailUtils
import android.graphics.Bitmap
import android.text.TextUtils


/**
 * Created by lsy
 * on 2019/3/27
 */
class ImageRespository {

    private val globalThreadPool = ThreadPoolExecutor(8, 8
            , 30, TimeUnit.SECONDS, LinkedBlockingQueue<Runnable>());

    val recordImageListMap = ArrayList<HashMap<String, Any>>()
    var finishOneTask = false
    val fileDir = Environment.getExternalStorageDirectory().absolutePath + "/.GMAlbum/.album";

    fun scareImg(realPath: String): Observable<Pair<String, String>> {
       return Observable.create(ObservableOnSubscribe<Pair<String, String>> {
            val pair = Pair<String,String>(realPath,MyUtil.scareImg(realPath, 200f, fileDir + "/" + getFileName(realPath)!! + ".png", 75))
            it.onNext(pair)
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    //: HashMap<String, ArrayList<HashMap<String, Any>>>

    fun scanPhoneImage(context: Context): Observable<HashMap<String, ArrayList<HashMap<String, Any>>>> {
        val file = File(fileDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!recordImageListMap.isEmpty() && finishOneTask) {
            return Observable.just(
                    toMap(context, recordImageListMap))
                    .subscribeOn(Schedulers.computation()).observeOn(AndroidSchedulers.mainThread())
        }
        return Observable.create(ObservableOnSubscribe<HashMap<String, ArrayList<HashMap<String, Any>>>> {
            val st = System.currentTimeMillis();
            val images = ThumbUtil.getAllPictures(context.applicationContext)
            val realImages = ImageScanner(context.applicationContext).queryMedia()
            Log.e("lsy", "  SIZE ${images.size}  ${realImages.size}")
            val iterator = realImages.iterator()
            while (iterator.hasNext()) {
                val it2 = iterator.next()
                for (item in images) {
                    if (item.id == it2.id) {
                        if (item.path != null && !TextUtils.isEmpty(item.path) && File(item.path).exists()) {
                            it2.path = item.path
                        }
                        it2.isVideo = false
                        break
                    }
                }
            }
            val videos = ThumbUtil.getAllVideos(context.applicationContext)
            val realVideos = VideoScanner(context.applicationContext).queryMedia()
            Log.e("lsy", "  SIZE ${videos.size}  ${realVideos.size}")
            val iteratorVideo = realVideos.iterator()
            while (iteratorVideo.hasNext()) {
                val it1 = iteratorVideo.next()
                for (item in videos) {
                    if (item.id == it1.id) {
                        if (item.path != null && !TextUtils.isEmpty(item.path) && File(item.path).exists()) {
                            it1.path = item.path
                        }
                        it1.isVideo = true
                        break
                    }
                }
            }
            realVideos.addAll(realImages)
            realVideos.sortByDescending {
                it.dateToken
            }
            Log.e("lsy", "  T15555 !!  " + (System.currentTimeMillis() - st))
            val finalMap = getFinalMap(context, realVideos)
            it.onNext(finalMap)
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
    }

    fun savePreviewImg(context: Context, listener: savePreviewListener) {
        val start = System.currentTimeMillis();
        val needSize = recordImageListMap.size;
        var currentSize = 0;
        var letSize = 10
        var noPathSize = 0;
        recordImageListMap.forEach {
            val any = it["path"]
            if (it["realPath"] == null) {
                return@forEach
            }
            val realPath = it["realPath"] as String
            globalThreadPool.execute {
                if (any == null) {
                    Log.e("lsy", " THREADMAME " + Thread.currentThread().name)
                    val tempFilePngString = fileDir + "/" + getFileName(realPath)!! + ".png";
                    val tempFilePngExists = File(tempFilePngString).exists()
//                        val tempFileJpgString = fileDir + "/" + getFileName(realPath)!! + ".jpg";
//                        val tempFileJpgExists = File(tempFileJpgString).exists()
//                        val tempFileJpegString = fileDir + "/" + getFileName(realPath)!! + ".jpeg"
//                        val tempFileJpegExists = File(tempFileJpegString).exists()
                    if (tempFilePngExists) {
                        it["path"] = tempFilePngString;
                        synchronized(this) {
                            currentSize++;
                            Log.e("lsy", "HAVE PATH ${noPathSize}  ${currentSize}  ${needSize}")
                            if (currentSize == needSize) {
                                Log.e("lsy", " 压缩完成  耗时：${System.currentTimeMillis() - start}")
                                //FINISH
                                listener.onSuccess(toMapSync(context, recordImageListMap))
                            }
                        }
                        return@execute
                    } else if (it["isVideo"] == "T") {
                        it["path"] = MyUtil.saveVideoImg("${fileDir}/${getFileName(realPath)!!}.png",
                                realPath, MediaStore.Images.Thumbnails.MICRO_KIND, 220, 220)
                    } else {
                        val time = System.currentTimeMillis();
//                            val get = Luban.with(context).setTargetDir(fileDir)
//                                    .setName(getFileName(realPath)!!)
//                                    .get(realPath);
//                            it["path"] = get.absolutePath;
                        it["path"] = MyUtil.scareImg(realPath, 200f, tempFilePngString, 75)
                        Log.e("lsy", "TIMM${System.currentTimeMillis() - time}")
                    }
                    //getImageCacheDir(context, Luban.DEFAULT_DISK_CACHE_DIR)!!.absolutePath
                    synchronized(this) {
                        currentSize++;
                        noPathSize++;
                        Log.e("lsy", "${noPathSize}  ${currentSize}  ${needSize}")
                        if (currentSize == needSize) {
                            Log.e("lsy", " 压缩完成  耗时：${System.currentTimeMillis() - start}")
                            //FINISH
                            listener.onSuccess(toMapSync(context, recordImageListMap))
                        } else {
                            if (noPathSize > letSize) {
                                letSize += 70
                                listener.onSuccess(toMapSync(context, recordImageListMap))
                            }
                        }
                    }
                } else {
                    synchronized(this) {
                        currentSize++;
                        Log.e("lsy", "HAVE PATH ${noPathSize}  ${currentSize}  ${needSize}")
                        if (currentSize == needSize) {
                            Log.e("lsy", " 压缩完成  耗时：${System.currentTimeMillis() - start}")
                            //FINISH
                            listener.onSuccess(toMapSync(context, recordImageListMap))
                        }
                    }
                }
            }
        }
    }

    interface savePreviewListener {
        fun onSuccess(data: HashMap<String, ArrayList<HashMap<String, Any>>>)
    }

    // val currentTimeMillis = System.currentTimeMillis();
    //        Thread {
    //            val queryMedia = ImageScanner(context).queryMedia()
    //            val needSize = queryMedia.size
    //            val newList = ArrayList<MediaFile>();
    //            val dir = getImageCacheDir(context, Luban.DEFAULT_DISK_CACHE_DIR)!!.absolutePath;
    //            queryMedia.forEach {
    //                val path = it.realPath!!
    //                val tempFilePngExists = File(dir + "/" + getFileName(path)!! + ".png").exists()
    //                val tempFileJpgExists = File(dir + "/" + getFileName(path)!! + ".jpg").exists();
    //                val tempFileJpegExists = File(dir + "/" + getFileName(path)!! + ".jpeg").exists()
    //
    //                if (it.size > 1024 * 1024 && !tempFilePngExists
    //                        && !tempFileJpgExists && !tempFileJpegExists) {
    //                    globalThreadPool.execute {
    //                        val get = Luban.with(context).setTargetDir(getImageCacheDir(context, Luban.DEFAULT_DISK_CACHE_DIR)!!.absolutePath)
    //                                .setName(getFileName(path)!!)
    //                                .get(path);
    //                        //                Log.e("lsy"," ${getFileFullName(path)!!}");
    //                        it.path = get.absolutePath
    //                        Log.e("lsy", "  ${get.absolutePath} ")
    //                        synchronized(this) {
    //                            newList.add(it);
    //                            Log.e("lsy", " ${newList.size} ${needSize}")
    //                            if (newList.size == needSize) {
    //                                //OKK
    //                                Log.e("lsy", "  TIME  ${System.currentTimeMillis() - currentTimeMillis}")
    //                            }
    //                        }
    //                    }
    //                } else {
    //                    synchronized(this) {
    //                        newList.add(it);
    //                        Log.e("lsy", " ${newList.size} ${needSize}")
    //                        if (newList.size == needSize) {
    //                            //OKK
    //                            Log.e("lsy", "  TIME  ${System.currentTimeMillis() - currentTimeMillis}")
    //                        }
    //                    }
    //                }
    //            }
    //        }.start()

    fun getFinalMap(context: Context, imageList: ArrayList<MediaFile>): HashMap<String, ArrayList<HashMap<String, Any>>> {
        val imageListMap = ArrayList<HashMap<String, Any>>();
        imageList.forEach {
            val itemMap = HashMap<String, Any>()
            it.folderName?.run {
                itemMap.put("folderName", this)
            }
            it.path?.run {
                itemMap.put("path", this)
            }
            it.size?.run {
                itemMap.put("size", this)
            }
            it.realPath?.run {
                itemMap.put("realPath", this)
            }
            it.isVideo?.run {
                if (this) {
                    itemMap.put("isVideo", "T")
                    itemMap.put("during", "${it.duration}")
                } else {
                    itemMap.put("isVideo", "F")
                }
            }
            imageListMap.add(itemMap)
        }
        synchronized(this) {
            recordImageListMap.clear()
            recordImageListMap.addAll(imageListMap)
            finishOneTask = true
        }
        //            imageList.clear();
        return toMap(context, imageListMap);
    }

    private fun toMap(context: Context, imageListMap: ArrayList<HashMap<String, Any>>): HashMap<String, ArrayList<HashMap<String, Any>>> {
        val finalList = HashMap<String, ArrayList<HashMap<String, Any>>>()
        imageListMap.forEach {
            it["folderName"]?.run {
                if (finalList[this] == null) {
                    finalList[this as String] = ArrayList<HashMap<String, Any>>()
                    if (it["path"] == null) {
                        val realPath = it["realPath"] as String
                        if (it["isVideo"] == "T") {
                            it["path"] = MyUtil.saveVideoImg("${fileDir}/${getFileName(realPath)!!}.png",
                                    realPath, MediaStore.Images.Thumbnails.MINI_KIND, 300, 300)
                        } else {
                            val png = File("${fileDir}/${getFileName(realPath)!!}.png")
//                            val jpg = File("${fileDir}/${getFileName(realPath)!!}.jpg")
//                            val jpeg = File("${fileDir}/${getFileName(realPath)!!}.jpeg")
                            if (png.exists()) {
                                it["path"] = png.absolutePath
                            } else {
//                                val get = Luban.with(context).setTargetDir(
//                                        fileDir
//                                )
//                                        .setName(getFileName(realPath)!!)
//                                        .get(realPath);
                                it["path"] = MyUtil.scareImg(realPath, 200f, fileDir + "/" + getFileName(realPath)!! + ".png", 75)
//                                Log.e("lsy", "封面照片 ${get.absolutePath}");
                            }
                        }
                    }
                    finalList[this]!!.add(it);
                } else {
                    finalList[this as String]!!.add(it);
                }
            }
        }
        finalList["IsGengmeiAlbumAllImages"] = imageListMap;
        return finalList;
    }

    private fun toMapSync(context: Context, imageListMap: ArrayList<HashMap<String, Any>>): HashMap<String, ArrayList<HashMap<String, Any>>> {
        val finalList = HashMap<String, ArrayList<HashMap<String, Any>>>()
        imageListMap.forEach {
            it["folderName"]?.run {
                if (finalList[this] == null) {
                    finalList[this as String] = ArrayList<HashMap<String, Any>>()
                    finalList[this]!!.add(it);
                } else {
                    finalList[this as String]!!.add(it);
                }
            }
        }
        finalList["IsGengmeiAlbumAllImages"] = imageListMap;
        return finalList;
    }

    companion object {
        private var instance: ImageRespository? = null
        const val TAG: String = "Image_Picker"

        fun getInstance(): ImageRespository {
            if (instance == null) {
                synchronized(ImageRespository::class.java) {
                    if (instance == null) {
                        instance = ImageRespository();
                    }
                }
            }
            return instance!!
        }
    }
}