package com.example.myimagepicker.repository.local

import android.content.Context
import com.example.myimagepicker.bean.MediaFile
import com.example.myimagepicker.bean.MediaFolder
import java.util.*

/**
 * Created by lsy
 * on 2019/3/27
 */
object MediaHandler {

    val ALL_MEDIA_FOLDER = -1//全部媒体
    val ALL_VIDEO_FOLDER = -2//全部视频

    /**
     * 对查询到的图片进行聚类（相册分类）
     *
     * @param context
     * @param imageFileList
     * @return
     */
    fun getImageFolder(context: Context, imageFileList: ArrayList<MediaFile>): List<MediaFolder> {
        return getMediaFolder(context, imageFileList, null)
    }


    /**
     * 对查询到的视频进行聚类（相册分类）
     *
     * @param context
     * @param imageFileList
     * @return
     */
    fun getVideoFolder(context: Context, imageFileList: ArrayList<MediaFile>): List<MediaFolder> {
        return getMediaFolder(context, null, imageFileList)
    }


    /**
     * 对查询到的图片和视频进行聚类（相册分类）
     *
     * @param context
     * @param imageFileList
     * @param videoFileList
     * @return
     */
    fun getMediaFolder(context: Context, imageFileList: ArrayList<MediaFile>?, videoFileList: ArrayList<MediaFile>?): List<MediaFolder> {

        //根据媒体所在文件夹Id进行聚类（相册）
        val mediaFolderMap = HashMap<Int, MediaFolder>()

        //全部图片、视频文件
        val mediaFileList = ArrayList<MediaFile>()
        if (imageFileList != null) {
            mediaFileList.addAll(imageFileList)
        }
        if (videoFileList != null) {
            mediaFileList.addAll(videoFileList)
        }
        //对媒体数据进行排序
//        mediaFileList.sortBy { it.dateToken }

        //全部图片或视频
        if (!mediaFileList.isEmpty()) {
            val allMediaFolder = MediaFolder(ALL_MEDIA_FOLDER, "图片和视频", mediaFileList[0].path!!, mediaFileList)
            mediaFolderMap[ALL_MEDIA_FOLDER] = allMediaFolder
        }

        //全部视频
        if (videoFileList != null && !videoFileList.isEmpty()) {
            val allVideoFolder = MediaFolder(ALL_VIDEO_FOLDER, "所有视频", videoFileList[0].path!!, videoFileList)
            mediaFolderMap[ALL_VIDEO_FOLDER] = allVideoFolder
        }

        //对图片进行文件夹分类
        if (imageFileList != null && !imageFileList.isEmpty()) {
            val size = imageFileList.size
            //添加其他的图片文件夹
            for (i in 0 until size) {
                val mediaFile = imageFileList[i]
                val imageFolderId = mediaFile.folderId
                var mediaFolder: MediaFolder? = mediaFolderMap[imageFolderId]
                if (mediaFolder == null) {
                    mediaFolder = MediaFolder(imageFolderId!!, mediaFile.folderName!!, mediaFile.path!!, ArrayList<MediaFile>())
                }
                val imageList = mediaFolder.mediaFileList
                imageList!!.add(mediaFile)
                mediaFolder.mediaFileList = imageList
                mediaFolderMap[imageFolderId!!] = mediaFolder
            }
        }

        //整理聚类数据
        val mediaFolderList = ArrayList<MediaFolder>()
        for (folderId in mediaFolderMap.keys) {
            if (folderId == ALL_MEDIA_FOLDER || folderId == ALL_VIDEO_FOLDER) {
                mediaFolderList.add(0,mediaFolderMap[folderId]!!)
            } else {
                mediaFolderList.add(mediaFolderMap[folderId]!!)
            }
        }
        return mediaFolderList
    }

}