package com.example.gengmei_flutter_plugin.ImagePlugin.repository.local;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.provider.MediaStore;
import android.util.Log;

import com.example.myimagepicker.bean.MediaFile;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * @author lsy
 * @date 2019-10-27
 */
public class ThumbUtil {

    public static ArrayList<MediaFile> getAllPictures(Context context) {
        long st = System.currentTimeMillis();

        ArrayList<MediaFile> scanList = new ArrayList<>();
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(
                MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI,
                new String[]{
                        MediaStore.Images.Thumbnails.IMAGE_ID,
                        MediaStore.Images.Thumbnails.DATA,
                        MediaStore.Images.Thumbnails.WIDTH,
                        MediaStore.Images.Thumbnails.HEIGHT,
                },
                null,
                null,
                null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                MediaFile mediaFile = new MediaFile();
                mediaFile.setId(cursor.getInt(0));
                mediaFile.setPath(cursor.getString(1));
                mediaFile.setWidth(cursor.getInt(2));
                mediaFile.setHeight(cursor.getInt(3));
                mediaFile.setVideo(false);
                scanList.add(mediaFile);
            } while (cursor.moveToNext());
            cursor.close();
        }
        Log.e("lsy", "  T1122 !!  " + (System.currentTimeMillis() - st));
        return scanList;
    }


//    public static ArrayList<MediaFile> getAllRealImages(Context context){
//        ArrayList<MediaFile> scanList = new ArrayList<>();
//        ContentResolver cr = context.getContentResolver();
//        Cursor cursor = cr.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
//                new String[]{
//                        MediaStore.Images.Media.DATA,
//                        MediaStore.Images.Media.MIME_TYPE,
//                        MediaStore.Images.Media.BUCKET_ID,
//                        MediaStore.Images.Media.BUCKET_DISPLAY_NAME,
//                        MediaStore.Images.Media.DATE_TAKEN,
//                        MediaStore.Images.Media.SIZE,
//                        MediaStore.Audio.Media._ID
//
//                },
//                MediaStore.Audio.Media._ID + "=" + file.getId(),
//                null,
//                MediaStore.Images.Media.DATE_TAKEN +
//                        " DESC"
//        );
//
//
//        for (int i = 0; i < scanList.size(); i++) {
//            MediaFile file = scanList.get(i);
//
//            if (cursor.moveToFirst()) {
//                do {
//                    String path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATA));
//                    String mime = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.MIME_TYPE));
//                    int folderId = cursor.getInt(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_ID));
//                    String folderName = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_DISPLAY_NAME));
//                    long dateToken = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.DATE_TAKEN));
//                    long size = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.SIZE));
//                    long aLong = cursor.getLong(6);
//                    Log.e("lsy", "  LONGGG  " + aLong);
//                    file.setRealPath(path);
//                    file.setMime(mime);
//                    file.setFolderId(folderId);
//                    file.setFolderName(folderName);
//                    file.setDateToken(dateToken);
//                    file.setSize(size);
//                    scanList.set(i, file);
//                } while (cursor.moveToNext());
//                cursor.close();
//            }
//        }
//        return scanList;
//    }


    public static ArrayList<MediaFile> getAllVideos(Context context) {
        ArrayList<MediaFile> scanList = new ArrayList<>();
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(
                MediaStore.Video.Thumbnails.EXTERNAL_CONTENT_URI,
                new String[]{
                        MediaStore.Video.Thumbnails.VIDEO_ID,
                        MediaStore.Video.Thumbnails.DATA,
                        MediaStore.Video.Thumbnails.WIDTH,
                        MediaStore.Video.Thumbnails.HEIGHT,
                },
                null,
                null,
                null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                MediaFile mediaFile = new MediaFile();
                mediaFile.setId(cursor.getInt(0));
                mediaFile.setPath(cursor.getString(1));
                mediaFile.setWidth(cursor.getInt(2));
                mediaFile.setHeight(cursor.getInt(3));
                scanList.add(mediaFile);
            } while (cursor.moveToNext());
            cursor.close();
        }
//        for (int i = 0; i < scanList.size(); i++) {
//            MediaFile file = scanList.get(i);
//            cursor = cr.query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI,
//                    new String[]{
//                            MediaStore.Video.Media.DATA,
//                            MediaStore.Video.Media.MIME_TYPE,
//                            MediaStore.Video.Media.BUCKET_ID,
//                            MediaStore.Video.Media.BUCKET_DISPLAY_NAME,
//                            MediaStore.Video.Media.DURATION,
//                            MediaStore.Video.Media.DATE_TAKEN,
//                            MediaStore.Images.Media.SIZE
//                    },
//                    MediaStore.Audio.Media._ID + "=" + file.getId(),
//                    null,
//                    MediaStore.Images.Media.DATE_TAKEN +
//                            " DESC"
//            );
//            if (cursor.moveToFirst()) {
//                do {
//                    String path = cursor.getString(cursor.getColumnIndex(MediaStore.Video.Media.DATA));
//                    String mime = cursor.getString(cursor.getColumnIndex(MediaStore.Video.Media.MIME_TYPE));
//                    int folderId = cursor.getInt(cursor.getColumnIndex(MediaStore.Video.Media.BUCKET_ID));
//                    String folderName = cursor.getString(cursor.getColumnIndex(MediaStore.Video.Media.BUCKET_DISPLAY_NAME));
//                    long duration = cursor.getLong(cursor.getColumnIndex(MediaStore.Video.Media.DURATION));
//                    long dateToken = cursor.getLong(cursor.getColumnIndex(MediaStore.Video.Media.DATE_TAKEN));
//                    file.setRealPath(path);
//                    file.setMime(mime);
//                    file.setFolderId(folderId);
//                    file.setFolderName(folderName);
//                    file.setDateToken(dateToken);
//                    file.setDuration(duration);
//                    scanList.set(i, file);
//                } while (cursor.moveToNext());
//                cursor.close();
//            }
//        }
        return scanList;
    }
}
