package com.example.myimagepicker.repository.local

import android.content.Context
import android.database.Cursor
import android.net.Uri
import android.os.Environment
import android.provider.MediaStore
import android.util.Log
import com.example.gengmei_flutter_plugin.utils.MyUtil
import com.example.myimagepicker.bean.MediaFile
import java.io.File

/**
 * Created by lsy
 * on 2019/3/27
 */

class VideoScanner(private val mContext: Context) : AbsMediaScanner<MediaFile>(mContext) {


    override val scanUri: Uri
        get() = MediaStore.Video.Media.EXTERNAL_CONTENT_URI

    override val projection: Array<String>
        get() =
            arrayOf(MediaStore.Video.Media.DATA,
//                    MediaStore.Video.Media.MIME_TYPE,
//                    MediaStore.Video.Media.BUCKET_ID,
                    MediaStore.Video.Media.BUCKET_DISPLAY_NAME,
                    MediaStore.Video.Media.DURATION,
                    MediaStore.Video.Media.DATE_TAKEN,
                    MediaStore.Images.Media.SIZE,
                    MediaStore.Audio.Media._ID
            )

    override val order: String
        get() = MediaStore.Video.Media.DATE_TAKEN + " desc"

    override val selectionArgs: Array<String>?
        //        get() = null
        get() = arrayOf("video/mp4", "video/avi")

    override val selection: String
        get() = (MediaStore.Video.Media.MIME_TYPE + "=? or "
                + MediaStore.Video.Media.MIME_TYPE + "=?")


    /**
     * 构建媒体对象
     *
     * @param cursor
     * @return
     */
    protected override fun parse(cursor: Cursor): MediaFile {

//        val path = cursor.getString(cursor.getColumnIndex(MediaStore.Video.Media.DATA))
//        val mime = cursor.getString(cursor.getColumnIndex(MediaStore.Video.Media.MIME_TYPE))
//        val folderId = cursor.getInt(cursor.getColumnIndex(MediaStore.Video.Media.BUCKET_ID))
//        val folderName = cursor.getString(cursor.getColumnIndex(MediaStore.Video.Media.BUCKET_DISPLAY_NAME))
//        val duration = cursor.getLong(cursor.getColumnIndex(MediaStore.Video.Media.DURATION))
//        val dateToken = cursor.getLong(cursor.getColumnIndex(MediaStore.Video.Media.DATE_TAKEN))
        val path = cursor.getString(0)
        val folderName = cursor.getString(1)
        val duration = cursor.getLong(2)
        val dateToken = cursor.getLong(3)
        val size = cursor.getLong(4)
        val id = cursor.getInt(5);


        val mediaFile = MediaFile()
        mediaFile.realPath = path
//        mediaFile.mime = mime
//        mediaFile.folderId = folderId
        mediaFile.folderName = folderName
        mediaFile.duration = duration
        mediaFile.dateToken = dateToken
        mediaFile.isVideo = true
        mediaFile.size=size
        mediaFile.id=id
//        val dir = Environment.getExternalStorageDirectory().absolutePath + "/GMAlbum/.album"
////        val dir = getImageCacheDir(context, Luban.DEFAULT_DISK_CACHE_DIR)!!.absolutePath;
//        val tempFilePngString = dir + "/" + MyUtil.getFileName(path)!! + ".png";
//        val tempFilePngExists = File(tempFilePngString).exists()
//        if (tempFilePngExists) {
//            mediaFile.path = tempFilePngString;
//        }
//        val tempFileJpgString = dir + "/" + MyUtil.getFileName(path)!! + ".jpg";
//        val tempFileJpgExists = File(tempFileJpgString).exists()
//        if (tempFileJpgExists) {
//            mediaFile.path = tempFileJpgString;
//        }
//        val tempFileJpegString = dir + "/" + MyUtil.getFileName(path)!! + ".jpeg"
//        val tempFileJpegExists = File(tempFileJpegString).exists()
//        if (tempFileJpegExists) {
//            mediaFile.path = tempFileJpegString;
//        }

        return mediaFile
    }

    companion object {

        val ALL_IMAGES_FOLDER = -1//全部图片
    }


}