package com.example.gengmei_flutter_plugin.utils

import android.widget.ImageView
import java.io.Serializable

/**
 * Created by lsy
 * on 2019/3/27
 */
interface ImageLoader : Serializable {

    /**
     * 缩略图加载方案
     *
     * @param imageView
     * @param imagePath
     */
    fun loadImage(imageView: ImageView, imagePath: String)

    /**
     * 大图加载方案
     *
     * @param imageView
     * @param imagePath
     */
    fun loadPreImage(imageView: ImageView, imagePath: String)


    /**
     * 视频播放方案
     *
     * @param imageView
     * @param path
     */
    //    void loadVideoPlay(ImageView imageView, String path);

    /**
     * 缓存管理
     */
    fun clearMemoryCache()

}