package com.example.gengmei_flutter_plugin.utils

import android.content.Context
import android.util.Log
import com.example.myimagepicker.luban.Luban
import java.io.File
import android.media.ThumbnailUtils
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.util.DebugUtils
import java.io.FileNotFoundException
import java.io.FileOutputStream
import java.io.IOException
import java.lang.Exception


/**
 * @author lsy
 * @date   2019-09-10
 */

class MyUtil {


    companion object {
        fun getImageCacheDir(context: Context, cacheName: String): File? {
            val cacheDir = context.externalCacheDir
            if (cacheDir != null) {
                val result = File(cacheDir, cacheName)
                return if (!result.mkdirs() && (!result.exists() || !result.isDirectory)) {
                    // File wasn't able to create a directory, or the result exists but not a directory
                    null
                } else result
            }
            if (Log.isLoggable(Luban.TAG, Log.ERROR)) {
                Log.e(Luban.TAG, "default disk cache dir is null")
            }
            return null
        }


        fun getFileName(pathandname: String): String? {
            val start = pathandname.lastIndexOf("/")
            val end = pathandname.lastIndexOf(".")
            return if (start != -1 && end != -1) {
                pathandname.substring(start + 1, end)
            } else {
                null
            }
        }

        fun getFileFullName(pathandname: String): String? {
            val start = pathandname.lastIndexOf("/")
            val end = pathandname.lastIndexOf(".")
            return if (start != -1 && end != -1) {
                pathandname.substring(start + 1, pathandname.length)
            } else {
                null
            }
        }

        fun saveVideoImg(filePath: String, videoPath: String, kind: Int, width: Int, height: Int): String {
            val file = File(filePath);
            var bitmap: Bitmap? = null
            // 获取视频的缩略图
            bitmap = ThumbnailUtils.createVideoThumbnail(videoPath, kind)
            if (width > 0 && height > 0) {
                bitmap = ThumbnailUtils.extractThumbnail(bitmap, width, height,
                        ThumbnailUtils.OPTIONS_RECYCLE_INPUT)
            }
            try {
                val out = FileOutputStream(file)
                bitmap.compress(Bitmap.CompressFormat.PNG, 80, out)
                out.flush()
                out.close()
                bitmap.recycle()
            } catch (e: Exception) {
                e.printStackTrace()
            }
            return filePath
        }

        fun scareImg(imgPath: String, scareSize: Float, filePath: String, quality: Int): String {
            val newOpts = BitmapFactory.Options()
            // 开始读入图片，此时把options.inJustDecodeBounds 设回true，即只读边不读内容
            newOpts.inJustDecodeBounds = true
            newOpts.inPreferredConfig = Bitmap.Config.RGB_565
            // 获取位图信息，但请注意位图现在为空
            var bitmap = BitmapFactory.decodeFile(imgPath, newOpts)

            newOpts.inJustDecodeBounds = false
            val w = newOpts.outWidth
            val h = newOpts.outHeight

            val max = Math.max(w, h)
            var scare = 1f
            if (max > scareSize) {
                scare = max / scareSize
            }
            // 想要缩放的目标尺寸,现在大部分手机都是1080*1920，参考值可以让宽高都缩小一倍
            //        float hh = w * scare;// 设置高度为960f时，可以明显看到图片缩小了
            //        float ww = h * scare;// 设置宽度为540f，可以明显看到图片缩小了
            //        // 缩放比。由于是固定比例缩放，只用高或者宽其中一个数据进行计算即可
            //        int be = 1;// be=1表示不缩放
            //        if (w > h && w > ww) {// 如果宽度大的话根据宽度固定大小缩放
            //            be = (int) (newOpts.outWidth / ww);
            //        } else if (w < h && h > hh) {// 如果高度高的话根据宽度固定大小缩放
            //            be = (int) (newOpts.outHeight / hh);
            //        }
            //        if (be <= 0)
            //            be = 1;
            newOpts.inSampleSize = scare.toInt()// 设置缩放比例
            // 开始压缩图片，注意此时已经把options.inJustDecodeBounds 设回false了
            bitmap = BitmapFactory.decodeFile(imgPath, newOpts)
            val file = File(filePath)
            try {
                val out = FileOutputStream(file)
                bitmap.compress(Bitmap.CompressFormat.PNG, quality, out)
                out.flush()
                out.close()
                bitmap.recycle()
            } catch (e: FileNotFoundException) {
                e.printStackTrace()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            return filePath
        }
    }


}
