/*
 * @author lsy
 * @date   2019-11-01
 **/
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gengmei_flutter_plugin_example/AlbumModel/page/preview/AlbumPreviewModel.dart';

class AlbumPreviewPage extends StatefulWidget {
  AlbumPreviewModel _model;
  String fromPage;

  AlbumPreviewPage(String imgPath, this.fromPage) {
    _model = AlbumPreviewModel(imgPath);
  }

  @override
  State<StatefulWidget> createState() => AlbumPreviewState(_model, fromPage);
}

class AlbumPreviewState extends State<AlbumPreviewPage> {
  AlbumPreviewModel _model;
  final String fromPage;

  AlbumPreviewState(this._model, this.fromPage);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("test"),
      ),
      body: ConstrainedBox(
          constraints: BoxConstraints.expand(),
          child: new Image.file(
            File(
              _model.imgPath,
            ),
            fit: BoxFit.fitWidth,
          )),
    );
  }

  @override
  String pageName() {
    return "album_preview";
  }

  @override
  String referrer() {
    return fromPage;
  }
}
