//
//  NSObject+ResultManager.m
//  gengmei_flutter_plugin
//
//  Created by Apple on 2019/9/25.
//

#import "ResultManager.h"

@interface ResultManager()

@property(nonatomic)NSMutableDictionary * map;
@end

@implementation ResultManager{
    
}

+ (instancetype)sharedSingleton {
    static ResultManager *_sharedSingleton = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _sharedSingleton = [[super allocWithZone:NULL] init];
    });
    return _sharedSingleton;
}

+ (instancetype)allocWithZone:(struct _NSZone *)zone {
    return [ResultManager sharedSingleton];
}
- (id)copyWithZone:(nullable NSZone *)zone {
    return [ResultManager sharedSingleton];
}
- (id)mutableCopyWithZone:(nullable NSZone *)zone {
    return [ResultManager sharedSingleton];
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        self.map=[[NSMutableDictionary alloc] init];
    }
    return self;
}

-(void) addResult:(NSNumber*)key :(FlutterResult)result{
    [self.map setObject:result forKey:key];
//    self.map[@"oo"]=result;
//    NSString* yu=@"oo";
//    NSString * temp=[NSString stringWithFormat:@"%ld",19l];
//    [self.map setObject:result forKey:yu];
}

-(void)resultSuccess:(NSNumber*)key :(id _Nullable)value{
    FlutterResult result=[self.map objectForKey:key];
    if (result!=nil) {
        result(value);
    }
    [self.map removeObjectForKey:key];
}

-(void)resultError:(NSNumber*)key :(NSString*)reason :(NSObject*)value{
    FlutterResult result=[self.map objectForKey:key];
    if(result!=nil){
        result([FlutterError errorWithCode:reason message:reason details:value]);
    }
    [self.map removeObjectForKey:key];
    NSLog(@"%ld",[self.map count]);
}


@end
