//
//  AVPlayerViewController.m
//  gengmei_flutter_plugin
//
//  Created by Apple on 2019/11/1.
//

#import <Foundation/Foundation.h>
#import "MyPlayerViewController.h"
#import <AVFoundation/AVFoundation.h>
#import <AVKit/AVKit.h>
#import <AssetsLibrary/AssetsLibrary.h>
#import <Photos/Photos.h>
@interface MyPlayerViewController()
@property(nonatomic)dispatch_queue_t queue;;
@end

@implementation MyPlayerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    self.queue =  dispatch_queue_create("com.gengmei_flutter_plugin", DISPATCH_QUEUE_SERIAL);
//    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
//    button.frame = CGRectMake(100, 100, 100, 100);
//    [button setTitle:@"TICK" forState:UIControlStateNormal];
//    button.backgroundColor = [UIColor brownColor];
//    [button addTarget:self action:@selector(playMovie) forControlEvents:UIControlEventTouchUpInside];
//    [self.view addSubview:button];
}

- (void)playMovie:(PHAsset*) assets{
    dispatch_async(self.queue, ^{
    
    PHVideoRequestOptions *options = [[PHVideoRequestOptions alloc] init];
    //    options.version = PHImageRequestOptionsVersionCurrent;
    options.networkAccessAllowed = true;
    //    options.deliveryMode = PHVideoRequestOptionsDeliveryModeAutomatic;
    [[PHImageManager defaultManager]requestAVAssetForVideo:assets options:options resultHandler:^(AVAsset * _Nullable asset, AVAudioMix * _Nullable audioMix, NSDictionary * _Nullable info) {
        dispatch_async(dispatch_get_main_queue(), ^{
            AVURLAsset *urlAsset = (AVURLAsset *)asset;
            //        AVPlayerViewController* video=[[AVPlayerViewController alloc] init];
            //        [viewController presentViewController:video animated:YES completion:nil];
            //        [video playMovie:urlAsset.URL];
            
            
            AVPlayer *player = [AVPlayer playerWithURL:urlAsset.URL];
            //    2.创建视频播放视图的控制器
            AVPlayerViewController *playerVC = [[AVPlayerViewController alloc]init];
            playerVC.player = player;
            playerVC.entersFullScreenWhenPlaybackBegins = YES;
            playerVC.exitsFullScreenWhenPlaybackEnds = YES;
            playerVC.videoGravity = AVLayerVideoGravityResizeAspect;
            playerVC.view.center = self.view.center;
            playerVC.view.frame = self.view.bounds;
            playerVC.showsPlaybackControls = YES;
            playerVC.view.translatesAutoresizingMaskIntoConstraints = YES;
            //    隐藏 控制控件
            //    playerVC.showsPlaybackControls = NO;
            
            //    [self presentViewController:playerVC animated:YES completion:nil];
            
            //    自定义位置
//            playerVC.view.frame = CGRectMake(200, 300, 300, 300);
            [self.view addSubview:playerVC.view];
            [self addChildViewController:playerVC];
//            if (playerVC.readyForDisplay) {
                [playerVC.player play];
//            }
        });
    }];
    });
    //    1.AVPlayer
    
}

@end
