/*
 * @author lsy
 * @date   2019-09-09
 **/
import 'package:flutter/foundation.dart';
import 'package:flutter/src/services/platform_channel.dart';

Map<String, List<ScanImageItem>> changData(Map images) {
  Map<String, List<ScanImageItem>> newMap = new Map();
  images.forEach((k, v) {
    List<ScanImageItem> tempList = new List();
    for (var item in v) {
      ScanImageItem scanImageItem = new ScanImageItem();
      scanImageItem.path = item["path"] ?? "";
      scanImageItem.size = item["size"] ?? 0;
      scanImageItem.realPath = item["realPath"] ?? "";
      scanImageItem.isVideo = item["isVideo"] == "T" ? true : false;
      scanImageItem.during = item["during"] ?? "0";
      scanImageItem.dataToken =
          item["dataToken"] == null ? 0 : int.parse(item["dataToken"]);
      tempList.add(scanImageItem);
    }
    newMap.putIfAbsent(k, () => tempList);
  });
  return newMap;
}

class ScanImagePlugn {
  static Future<Map<String, List<ScanImageItem>>> scanImages(
      MethodChannel channel) async {
    var images = await channel.invokeMapMethod("scan_image_picker");
    return Future.value(compute(changData, images));
  }

  static Future<Map> nativeCamera(
      MethodChannel channel, String authority) async {
    return await channel
        .invokeMethod("native_camera", {"authority": authority});
  }

  static Future<bool> quitPage(MethodChannel channel) async {
    return await channel.invokeMethod("quit_page");
  }

  static Future<List> ios_album_path(
      MethodChannel channel, List<String> path) async {
    return await channel.invokeMethod("IOS_IMAGE_BY_PATH", path);
  }

  static Future<Map> ios_album_item(MethodChannel channel, String path) async {
    return await channel.invokeMethod("IOS_IMAGE_ITEM", path);
  }

  static Future<bool> playAlbumVideo(MethodChannel channel, String path) async {
    return await channel.invokeMethod("play_album_video", path);
  }
}

class ScanImageItem {
  String path;
  String realPath;
  String during;
  bool isVideo;
  int dataToken;
  int size;
}
