import 'dart:async';
import 'dart:core';

import 'package:flutter/cupertino.dart';
import 'package:flutter/services.dart';
import 'package:gengmei_flutter_plugin/ScanImagePlugn.dart';
import 'package:gengmei_flutter_plugin/SharedPlugin.dart';

class GengmeiFlutterPlugin {
  static const MethodChannel _channel =
      const MethodChannel('gengmei_flutter_plugin');

  static const EventChannel _eventChannel =
      const EventChannel('gengmei_flutter_plugin_event');

  static get phoneImagesEvent => _eventChannel;

  static Future<Map<String, List<ScanImageItem>>> phoneImages() async {
    return await ScanImagePlugn.scanImages(_channel);
  }

  static Future<Map> nativeCamera(String authority) async {
    return await ScanImagePlugn.nativeCamera(_channel, authority);
  }

  static Future<List> ios_album_path(List<String> path) async {
    return await ScanImagePlugn.ios_album_path(_channel, path);
  }

  static Future<Map> ios_album_item(String path) async {
    return await ScanImagePlugn.ios_album_item(_channel, path);
  }

  static Future<bool> playAlbumVideo(String path) async {
    return await ScanImagePlugn.playAlbumVideo(_channel, path);
  }

  static Future<bool> quitPage() async {
    return await ScanImagePlugn.quitPage(_channel);
  }

  static Future<int> getInt(String key, int value) async {
    return await SharedPlugin.getInt(key, value, _channel);
  }

  static Future<double> getDouble(String key, double value) async {
    return await SharedPlugin.getDouble(key, value, _channel);
  }

  static Future<String> getString(String key, String value) async {
    return await SharedPlugin.getString(key, value, _channel);
  }

  static Future<bool> getbool(String key, bool value) async {
    return await SharedPlugin.getBoolean(key, value, _channel);
  }

  static Future<List<String>> getStringList(
      String key, List<String> value) async {
    return await SharedPlugin.getStringList(key, value, _channel);
  }

  static Future<bool> saveString(String key, String value) async {
    return await SharedPlugin.saveString(key, value, _channel);
  }

  static Future<bool> saveInt(String key, int value) async {
    return await SharedPlugin.saveInt(key, value, _channel);
  }

  static Future<bool> saveDouble(String key, double value) async {
    return await SharedPlugin.saveDouble(key, value, _channel);
  }

  static Future<bool> saveBool(String key, bool value) async {
    return await SharedPlugin.saveBoolean(key, value, _channel);
  }

  static Future<bool> saveStringList(String key, List<String> value) async {
    return await SharedPlugin.saveStringList(key, value, _channel);
  }

  static Future<bool> clearShare() async {
    return await SharedPlugin.clear(_channel);
  }
}
