package com.example.myimagepicker.repository.local

import android.content.Context
import android.database.Cursor
import android.graphics.BitmapFactory
import android.net.Uri
import android.os.Environment
import android.provider.MediaStore
import android.util.Log
import com.example.gengmei_flutter_plugin.utils.MyUtil.Companion.getFileName
import com.example.gengmei_flutter_plugin.utils.MyUtil.Companion.getImageCacheDir
import com.example.myimagepicker.bean.MediaFile
import com.example.myimagepicker.luban.Luban
import java.io.File

/**
 * Created by lsy
 * on 2019/3/27
 */
class ImageScanner(var context: Context) : AbsMediaScanner<MediaFile>(context) {

    override val scanUri: Uri
        get() = MediaStore.Images.Media.EXTERNAL_CONTENT_URI

    override val projection: Array<String>
        get() =
            arrayOf(MediaStore.Images.Media.DATA, MediaStore.Images.Media.MIME_TYPE, MediaStore.Images.Media.BUCKET_ID, MediaStore.Images.Media.BUCKET_DISPLAY_NAME, MediaStore.Images.Media.DATE_TAKEN, MediaStore.Images.Media.SIZE)

    override val selection: String
        get() =
            MediaStore.Images.Media.MIME_TYPE + "=? or " + MediaStore.Images.Media.MIME_TYPE + "=?" + " or " + MediaStore.Images.Media.MIME_TYPE + "=?"

    override val selectionArgs: Array<String>
        get() = arrayOf("image/jpeg", "image/png", "image/jpg"
//                , "image/gif"
        )

    override val order: String
        get() = MediaStore.Images.Media.DATE_TAKEN +
                " DESC"

    /**
     * 构建媒体对象
     *
     * @param cursor
     * @return
     */
    override fun parse(cursor: Cursor): MediaFile {
        val path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATA))
        val mime = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.MIME_TYPE))
        val folderId = cursor.getInt(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_ID))
        val folderName = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_DISPLAY_NAME))
        val dateToken = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.DATE_TAKEN))
        val size = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.SIZE))
        val mediaFile = MediaFile()

        mediaFile.mime = mime
        mediaFile.folderId = folderId
        mediaFile.folderName = folderName
        mediaFile.dateToken = dateToken
        mediaFile.size = size
        mediaFile.realPath = path
        val dir = Environment.getExternalStorageDirectory().absolutePath + "/GMAlbum/.album";
//        val dir = getImageCacheDir(context, Luban.DEFAULT_DISK_CACHE_DIR)!!.absolutePath;
        val tempFilePngString = dir + "/" + getFileName(path)!! + ".png";
        val tempFilePngExists = File(tempFilePngString).exists()
        if (tempFilePngExists) {
            mediaFile.path = tempFilePngString;
        }
        val tempFileJpgString = dir + "/" + getFileName(path)!! + ".jpg";
        val tempFileJpgExists = File(tempFileJpgString).exists()
        if (tempFileJpgExists) {
            mediaFile.path = tempFileJpgString;
        }
        val tempFileJpegString = dir + "/" + getFileName(path)!! + ".jpeg"
        val tempFileJpegExists = File(tempFileJpegString).exists()
        if (tempFileJpegExists) {
            mediaFile.path = tempFileJpegString;
        }
        if (size < 1024 * 100) {
            mediaFile.path = path
        }
        //
        //                if (it.size > 1024 * 1024 && !tempFilePngExists
        //                        && !tempFileJpgExists && !tempFileJpegExists) {
        //                    globalThreadPool.execute {
        //                        val get = Luban.with(context).setTargetDir(getImageCacheDir(context, Luban.DEFAULT_DISK_CACHE_DIR)!!.absolutePath)
        //                                .setName(getFileName(path)!!)
        //                                .get(path);


//        val options = BitmapFactory.Options();
//        options.inJustDecodeBounds = true;
//        BitmapFactory.decodeFile(path, options);
//        if (options.outHeight >= MAX_SIZE || options.outHeight / options.outWidth > MAX_SCALE) {
//            mediaFile.isBigIm = true
////            mediaFile.bigScare = Utils.getImageScale(context, path)
//        }
        return mediaFile
    }


    companion object {
        private const val MAX_SIZE = 4096 * 2
        private const val MAX_SCALE = 8
    }
}
