package com.example.gengmei_flutter_plugin.utils

import android.content.Context
import android.util.Log
import com.example.myimagepicker.luban.Luban
import java.io.File

/**
 * @author lsy
 * @date   2019-09-10
 */

class MyUtil {


    companion object{
        fun getImageCacheDir(context: Context, cacheName: String): File? {
            val cacheDir = context.externalCacheDir
            if (cacheDir != null) {
                val result = File(cacheDir, cacheName)
                return if (!result.mkdirs() && (!result.exists() || !result.isDirectory)) {
                    // File wasn't able to create a directory, or the result exists but not a directory
                    null
                } else result
            }
            if (Log.isLoggable(Luban.TAG, Log.ERROR)) {
                Log.e(Luban.TAG, "default disk cache dir is null")
            }
            return null
        }


        fun getFileName(pathandname: String): String? {
            val start = pathandname.lastIndexOf("/")
            val end = pathandname.lastIndexOf(".")
            return if (start != -1 && end != -1) {
                pathandname.substring(start + 1, end)
            } else {
                null
            }
        }

        fun getFileFullName(pathandname: String): String? {
            val start = pathandname.lastIndexOf("/")
            val end = pathandname.lastIndexOf(".")
            return if (start != -1 && end != -1) {
                pathandname.substring(start + 1, pathandname.length)
            } else {
                null
            }
        }
    }
}
