/*
 * @author lsy
 * @date   2019-09-09
 **/
import 'package:flutter/src/services/platform_channel.dart';

class ScanImagePlugn {
  static Future<Map<String, List<ScanImageItem>>> scanImages(
      MethodChannel channel) async {
    var images = await channel.invokeMapMethod("scan_image_picker");
    Map<String, List<ScanImageItem>> newMap = new Map();
    images.forEach((k, v) {
      List<ScanImageItem> tempList = new List();
      print("-------UP  ${k} ${tempList.length}");
      for (var item in v) {
        ScanImageItem scanImageItem = new ScanImageItem();
        scanImageItem.path = item["path"];
        scanImageItem.size = item["size"];
        scanImageItem.realPath = item["realPath"];
        tempList.add(scanImageItem);
      }
      newMap.putIfAbsent(k, () => tempList);
    });
    return newMap;
  }

  static Future<String> nativeCamera(
      MethodChannel channel, String authority) async {
    return await channel
        .invokeMethod("native_camera", {"authority": authority});
  }

  static Future<bool> quitPage(MethodChannel channel) async {
    return await channel.invokeMethod("quit_page");
  }
}

class ScanImageItem {
  String path;
  String realPath;
  int size;
  bool isSelected = false;
}
