/*
 * @Author: zx 
 * @Date: 2020-07-04 11:51:02 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-04 12:52:22
 */

class DiscussLowPriceAuthBean {
  int error;
  String message;
  Map extra;
  Map errorExtra;
  UserType userType;
  Data data;

  DiscussLowPriceAuthBean(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  DiscussLowPriceAuthBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  bool success;

  Data({this.success});

  Data.fromJson(Map<String, dynamic> json) {
    success = json['success'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    return data;
  }
}
