/*
 * @author lsy
 * @date   2020/5/20
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/src/widgets/framework.dart';
import 'package:flutter_common/commonModel/picker/base/BaseCenterPicker.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class TwoTextPicker implements ICenterPicker {
  final String title;
  final String content1;
  final String content2;
  VoidCallback dismissCall;

  TwoTextPicker(this.title, this.content1, this.content2);

  @override
  Widget build(BuildContext context, int alp) {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(12),
        color: Color.fromARGB(alp, 255, 255, 255),
      ),
      width: 285,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisSize: MainAxisSize.min,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(top: 16),
            child: Text(
              title,
              textScaleFactor: 1.0,
              style: TextStyle(
                  decoration: TextDecoration.none,
                  fontSize: 16,
                  color: Color.fromARGB(alp, 40, 40, 40),
                  fontStyle: FontStyle.normal,
                  fontWeight: FontWeight.w600),
            ),
          ),
          Container(
            margin: EdgeInsets.only(top: 18),
            child: baseText(content1, 14, Color.fromARGB(alp, 102, 102, 102)),
          ),
          Container(
            margin: EdgeInsets.only(top: 12),
            child: baseText(content2, 14, Color.fromARGB(alp, 102, 102, 102)),
          ),
          Container(
            height: 18,
          ),
          baseDivide(0),
          InkWell(
            onTap: () {
              dismissCall();
            },
            child: Container(
              width: double.maxFinite,
              height: 48,
              alignment: Alignment.center,
              child: baseText("确定", 16, Color.fromARGB(alp, 32, 189, 187)),
            ),
          )
        ],
      ),
    );
  }

  @override
  void dispose() {}

  @override
  void initState(dismissCall, BuildContext context) {
    this.dismissCall = dismissCall;
  }
}
