/*
 * @author lsy
 * @date   2020/5/19
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';

import 'BaseMenuListener.dart';

class BasePopMenu extends StatefulWidget {
  final double leftPos;
  final double topPos;
  final double width;
  final double height;
  final int maxHeight;
  final Widget child;
  final BaseMenuListener listener;
  final Function(double progress) proListener;

  BasePopMenu(
      {this.leftPos,
      this.topPos,
      this.maxHeight,
      this.width,
      this.height,
      this.child,
      this.listener,
      this.proListener});

  @override
  State<StatefulWidget> createState() {
    return BasePopMenuState();
    ;
  }
}

class BasePopMenuState extends State<BasePopMenu>
    with TickerProviderStateMixin {
  Animation<double> animation;
  AnimationController animationController;
  LiveData<double> _liveData = LiveData();
  bool isOpen = false;
  bool isDestory = false;

  @override
  void initState() {
    super.initState();
    animationController = new AnimationController(
        duration: const Duration(milliseconds: 300), vsync: this)
      ..addListener(() {
        _liveData.notifyView(animation.value * widget.maxHeight);
        if (widget.proListener != null && !isDestory) {
          widget.proListener(animation.value);
        }
      });
    animation = new Tween(begin: 0.0, end: 1.0).animate(animationController);
    widget.listener.addListener(() {
      if (widget.listener.isShow) {
        animationController.forward();
      } else {
        animationController.reverse();
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Positioned(
        left: widget.leftPos,
        top: widget.topPos,
        width: widget.width,
        height: widget.height,
        child: StreamBuilder(
          stream: _liveData.stream,
          initialData: 0.0,
          builder: (c, data) {
            return Container(
              height: data.data,
              child: widget.child,
            );
          },
        ));
  }

  @override
  void dispose() {
    isDestory = true;
    _liveData.dispost();
    animationController.dispose();
    super.dispose();
  }
}
