/*
 * @author lsy
 * @date   2020/5/20
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class DartToastView extends StatelessWidget {
  final Widget leftChild;
  final String rightText;

  DartToastView({this.leftChild, this.rightText});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 43,
      alignment: Alignment.center,
      child: Container(
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(5.0),
              color: Color(0xcc1D2530)),
          child: Row(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(left: 19, top: 13.5, bottom: 13.5),
                width: 16,
                height: 16,
                child: leftChild,
              ),
              Container(
                width: 8,
                height: 1,
              ),
              baseText(rightText, 13, Colors.white),
              Container(
                width: 19,
                height: 1,
              )
            ],
          )),
    );
  }
}
