/*
 * @Author: zx 
 * @Date: 2020-07-03 20:54:59 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-04 10:36:22
 */
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/ClueModel/server/entity/DiscussLowPriceModelBean.dart';

class DiscussLowPriceModel extends BaseModel {
  LiveData<Pair<int, DiscussLowPriceModelBean>> popViewLive = LiveData();
  RxDispose rxDispose = RxDispose();

  fetchPopviewData(String plan_id, String hospital_id, String doctor_id) {
    ClueApiImpl.getInstance()
        .getPopviewData(
            DioUtil.getInstance().getDio(), plan_id, hospital_id, doctor_id)
        .listen((event) {
          if (event.error == 0) {
            if (event.data == null) {
              popViewLive.notifyView(Pair(ENDLOADING, null));
            } else {
              popViewLive.notifyView(Pair(ENDLOADING, event.data));
            }
          } else {
            NativeToast.showNativeToast(event.message);
            popViewLive.notifyView(Pair(FAIL, null));
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          popViewLive.notifyView(Pair(FAIL, null));
          NativeToast.showNativeToast(err.message);
        });
  }

  @override
  void dispose() {
    popViewLive.dispost();
  }
}
