/*
 * @Author: zx 
 * @Date: 2020-07-03 13:53:16 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-04 11:31:00
 */
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseCenterPicker.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/ClueModel/page/DiscussLowPrice/DiscussLowPriceModel.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

class DiscussLowPricePopView {
  static void showPopView(BuildContext content) {
    BaseCenterPicker()
      ..setPicker(_PopView())
      ..show(content);
  }
}

class _PopView implements ICenterPicker {
  VoidCallback dismissCallback;
  double contentWidth;
  DiscussLowPriceModel _model = new DiscussLowPriceModel();
  @override
  Widget build(BuildContext context, int alp) {
    contentWidth = MediaQuery.of(context).size.width - 72;
    return StreamBuilder(
        stream: _model.popViewLive.stream,
        initialData: _model.popViewLive ?? Pair(LOADING, null),
        builder: (c, data) {
          if (data.data.second == null || data.data.first == FAIL) {
            return Container(
              height: 0,
              width: 0,
            );
          }
          return Container(
              width: contentWidth,
              alignment: AlignmentDirectional.center,
              child: Container(
                  child: Container(
                margin: EdgeInsets.fromLTRB(0, 0, 0, 0),
                child: Stack(
                    alignment: AlignmentDirectional.topCenter,
                    children: <Widget>[
                      Column(
                          mainAxisSize: MainAxisSize.min,
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: <Widget>[
                            Container(
                              height: 42.5,
                              width: contentWidth,
                            ),
                            Container(
                                margin: EdgeInsets.only(bottom: 0),
                                child: Stack(children: <Widget>[
                                  Container(
                                    child: setupBodyView(),
                                  ),
                                  Positioned(
                                      top: 20,
                                      right: 20,
                                      width: 16,
                                      height: 16,
                                      child: GestureDetector(
                                        onTap: () {
                                          dismissCallback();
                                        },
                                        child: Image.asset(
                                            'assets/discuss_loe_price_cancel.png',
                                            fit: BoxFit.cover),
                                      ))
                                ]))
                          ]),
                      Container(
                        margin: EdgeInsets.only(top: 0),
                        width: 85,
                        height: 85,
                        child: Image.network(
                            _model.popViewLive.data.second.icon,
                            fit: BoxFit.cover),
                      )
                    ]),
              )));
        });
  }

  setupBodyView() {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(7),
        color: Colors.white,
      ),
      child: Container(
        alignment: Alignment.center,
        margin: EdgeInsets.only(bottom: 0, top: 42.5),
        child: detailView(),
      ),
    );
  }

  detailView() {
    return Container(
      child: Column(
          mainAxisSize: MainAxisSize.min,
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Container(
              height: 19,
              margin: EdgeInsets.only(bottom: 14),
              alignment: AlignmentDirectional.center,
              child: Row(mainAxisSize: MainAxisSize.min, children: <Widget>[
                Container(
                    width: 16,
                    height: 16,
                    child: Image.asset(
                      'assets/discuss_loe_price_like.png',
                      fit: BoxFit.cover,
                    )),
                Container(
                  margin: EdgeInsets.only(left: 4),
                  child: baseText(_model.popViewLive.data.second.tip, 14,
                      Color(0xff848484)),
                )
              ]),
            ),
            Container(
                alignment: AlignmentDirectional.center,
                width: contentWidth - 70,
                margin: EdgeInsets.only(bottom: 25),
                child: baseText(
                    _model.popViewLive.data.second.title, 18, Color(0xff464646),
                    bold: true)),
            Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(7),
                  color: Color(0xffECECEC),
                ),
                alignment: Alignment.center,
                margin: EdgeInsets.only(bottom: 12),
                width: contentWidth - 70,
                height: 37,
                child: baseText(_model.popViewLive.data.second.authorizePhone,
                    16, Color(0xff484848))),
            Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(7),
                ),
                child: GestureDetector(
                    onTap: () {
                      // FlutterBoost.singleton.closeByContext(context);
                    },
                    child: Container(
                        margin: EdgeInsets.only(bottom: 14),
                        width: contentWidth - 70,
                        height: 37,
                        child: Image.asset('assets/discuss_loe_price_auth.png',
                            fit: BoxFit.cover)))),
            Container(
                width: contentWidth - 70,
                margin: EdgeInsets.only(bottom: 25),
                alignment: AlignmentDirectional.center,
                child:
                    baseText('授权后，您的手机将以“虚拟号”方式提供给机构', 11, Color(0xff999999))),
          ]),
    );
  }

  @override
  void dispose() {}

  @override
  void initState(VoidCallback dismissCall, BuildContext context) {
    this.dismissCallback = dismissCall;
    _model.fetchPopviewData('1', '2', '3');
  }
}
