/*
 * @author lsy
 * @date   2019-12-17
 **/
import 'package:flutter/material.dart';


abstract class BaseState<T extends StatefulWidget> extends State<T> {
  Widget buildItem(BuildContext context);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      child: buildItem(context),
      onWillPop: () {
        onWillPop();
      },
    );
  }

  void onWillPop(){
    Navigator.pop(context);
  }
}
