import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

import 'CallBackCompareItem.dart';

class PlansCompareFeedItemView extends StatefulWidget {
  Plans plan;
  CallBackCompareItem compareItem;
  Set<int> _setCompare;

  PlansCompareFeedItemView(this.plan, this.compareItem, this._setCompare);

  @override
  State<StatefulWidget> createState() => _PlansCompareFeedItemViewState();
}

class _PlansCompareFeedItemViewState
    extends BaseState<PlansCompareFeedItemView> {
  ImageIcon _checked = ImageIcon(AssetImage("assets/icon_compare_select.png"));

  ImageIcon _unchecked =
      ImageIcon(AssetImage("assets/icon_compare_unselect.png"));
  ImageIcon _icon = ImageIcon(AssetImage("assets/icon_compare_unselect.png"));

  @override
  Widget buildItem(BuildContext context) {
    return Container(
        margin: EdgeInsets.only(left: 15, right: 15), child: getItem());
  }

  getItem() {
    if (widget.plan.planType == 2) {
      return getFirstLevelItem();
    } else {
      return getSecondLevelItem();
    }
  }

  getFirstLevelItem() {
    return Container(
      width: double.maxFinite,
      height: 90,
      alignment: Alignment.centerLeft,
      padding: EdgeInsets.only(top: 20, bottom: 20),
      child: Row(
        children: <Widget>[
          IconButton(
            icon: _icon,
            onPressed: () => onClickCheckBox(_icon),
          ),
          Container(
            margin: EdgeInsets.only(left: 15, right: 15),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(2.0),
              child: Image.network(
                widget.plan.projectImage,
                width: 50,
                height: 50,
                fit: BoxFit.fill,
              ),
            ),
          ),
          Container(
            height: 50,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  margin: EdgeInsets.only(top: 2, bottom: 5),
                  child: Row(
                    children: <Widget>[
                      baseText(widget.plan.name, 14, Color(0xFF282828),
                          bold: true),
                      baseText("     好评率 ", 11, Color(0xFF282828)),
                      baseText(widget.plan.positiveRate, 14, Color(0xFFFF5963),
                          bold: true),
                    ],
                  ),
                ),
                Row(
                  children: <Widget>[
                    baseText('￥${widget.plan.minPrice}-${widget.plan.maxPrice}',
                        13, Color(0xFFFF5963)),
                    baseText("     销量${widget.plan.salesCount}", 11,
                        Color(0xFF282828))
                  ],
                )
              ],
            ),
          )
        ],
      ),
    );
  }

  getSecondLevelItem() {
    return Container(
      height: 77,
      child: Row(
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(right: 15.0),
            alignment: Alignment.centerLeft,
            child: IconButton(
              icon: _icon,
              onPressed: () => onClickCheckBox(_icon),
            ),
          ),
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(top: 13.0, bottom: 12),
                child: baseText(widget.plan.name, 14, Color(0xFF282828),
                    bold: true),
              ),
              Row(
                children: <Widget>[
                  baseText('￥${widget.plan.minPrice}-${widget.plan.maxPrice}',
                      13, Color(0xFFFF5963)),
                  Container(
                      width: 160,
                      alignment: Alignment.centerRight,
                      child: baseText("指导价：￥${widget.plan.guidePrice}", 11,
                          Color(0xFF282828))),
                ],
              ),
            ],
          )
        ],
      ),
    );
  }

  onClickCheckBox(ImageIcon icon) {
    if (icon == _checked) {
      _icon = _unchecked;
    } else {
      if (widget._setCompare.length == 2) {
        NativeToast.showNativeToast("不许再选了两个够了！");
        return;
      }
      _icon = _checked;
    }
    setState(() {
      widget.compareItem.checkedItem(widget.plan.planId);
    });
  }
}
