/*
 * @author lsy
 * @date   2020/7/3
 **/
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

class TopListModel extends BaseModel {
  LiveData<int> stateLive = LiveData();
  String tagId;
  String rankId = "";
  int page = 1;
  RxDispose rxDispose = RxDispose();
  LiveData<List<Plans>> datasLive = LiveData();
  List<Plans> datas = [];

  @override
  void dispose() {
    rxDispose.dispose();
    stateLive.dispost();
  }

  void getData(bool clear) {
    if (clear) {
      page = 1;
      datas.clear();
    }
    ClueApiImpl.getInstance()
        .getPlanFeed(
            DioUtil.getInstance().getDio(), tagId, "", "", "", "", rankId, page)
        .listen((event) {
          if (event.error == 0) {
            if (event.data.plans == null || event.data.plans.isEmpty) {
              if (page == 1) {
                stateLive.notifyView(EMPTY);
              } else {
                datasLive.notifyView([]);
              }
            } else {
              stateLive.notifyView(ENDLOADING);
              datas.addAll(event.data.plans);
              datasLive.notifyView(datas);
            }
          } else {
            NativeToast.showNativeToast(event.message);
            stateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  void loadMore() {
    page++;
    getData(false);
  }
}
