/*
 * @author lsy
 * @date   2020/7/2
 **/
import 'package:dio/dio.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBarBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:gm_flutter/main.mark.dart';

class TopModel extends BaseModel {
  int tabIndex = 0;
  List<Tabs> tabs = [];

  LiveData<String> titleLive = new LiveData();
  LiveData<String> imageLive = LiveData();
  LiveData<double> textLive = LiveData();
  LiveData<int> stateLive = LiveData();
  RxDispose rxDispose = RxDispose();
  String rank_type;
  String imageUrl;

  @override
  void dispose() {
    rxDispose.dispose();
    titleLive.dispost();
    imageLive.dispost();
    stateLive.dispost();
    textLive.dispost();
  }

  void selectTab(int index) {
    if (tabIndex == index) {
      return;
    }
    tabIndex = index;
    Map<String, dynamic> map = {
      "page_name": "favor_plan",
      "referrer": "plan_home",
      "referrer": "plan_home",
      "referrer_id": "",
      "referrer_link": ["plan_home"],
      "from_tab_name": "",
      "tab_name": tabs[index].name,
    };
    RouterCenterImpl().findMainRouter().buriedEvent("on_click_tab", map);
  }

  void init(VoidCallback back) {
    ClueApiImpl.getInstance()
        .getPlanBar(DioUtil.getInstance().getDio(), rank_type)
        .listen((event) {
          if (event.error == 0) {
            stateLive.notifyView(ENDLOADING);
            imageUrl = event.data.bannerImage;
            tabs = event.data.tabs;
            back();
          } else {
            NativeToast.showNativeToast(event.message);
            stateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((error) {
          PrintUtil.printBug(error);
          stateLive.notifyView(FAIL);
        });
  }
}
