class PlansCompareFeed {
  int error;
  String message;
  Map extra;
  Map errorExtra;
  UserType userType;
  Data data;

  PlansCompareFeed(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  PlansCompareFeed.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  List<Plans> plans;

  Data({this.plans});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['plans'] != null) {
      plans = new List<Plans>();
      json['plans'].forEach((v) {
        plans.add(new Plans.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.plans != null) {
      data['plans'] = this.plans.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Plans {
  int planId;
  int planType;
  String cardType;
  String name;
  String positiveRate;
  String salesCount;
  String minPrice;
  String maxPrice;
  String projectImage;
  String guidePrice;

  Plans(
      {this.planId,
      this.planType,
      this.cardType,
      this.name,
      this.positiveRate,
      this.salesCount,
      this.minPrice,
      this.maxPrice,
      this.projectImage,
      this.guidePrice});

  Plans.fromJson(Map<String, dynamic> json) {
    planId = json['plan_id'];
    planType = json['plan_type'];
    cardType = json['card_type'];
    name = json['name'];
    positiveRate = json['positive_rate'];
    salesCount = json['sales_count'];
    minPrice = json['min_price'];
    maxPrice = json['max_price'];
    projectImage = json['project_image'];
    guidePrice = json['guide_price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['plan_id'] = this.planId;
    data['plan_type'] = this.planType;
    data['card_type'] = this.cardType;
    data['name'] = this.name;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    data['min_price'] = this.minPrice;
    data['max_price'] = this.maxPrice;
    data['project_image'] = this.projectImage;
    data['guide_price'] = this.guidePrice;
    return data;
  }
}
