/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/cupertino.dart';

class FiveStarView extends StatelessWidget {
  final int allStarCount;
  final int lightStarCount;
  String starAssets;

  FiveStarView(this.lightStarCount, this.allStarCount, {this.starAssets});

  @override
  Widget build(BuildContext context) {
    List<Widget> list = new List();
    for (int i = 0; i < allStarCount; i++) {
      if (i <= lightStarCount) {
        list.add(Container(
          height: 13,
          width: 13,
          child: Image.asset(starAssets ?? "assets/sel_star.png"),
        ));
        if ( i != allStarCount - 1) {
          list.add(Container(
            height: 1,
            width: 2,
          ));
        }
      } else {
        list.add(Container(
          height: 13,
          width: 13,
          child: Image.asset("assets/normal_star.png"),
        ));
        if ( i != allStarCount - 1) {
          list.add(Container(
            height: 1,
            width: 2,
          ));
        }
      }
    }
    return Row(
      mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: list,
    );
  }
}
