/*
 * @author lsy
 * @date   2019-12-17
 **/
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/main.mark.dart';

abstract class BaseState<T extends StatefulWidget> extends State<T> {
  Widget buildItem(BuildContext context);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      child: buildItem(context),
      onWillPop: () {
        onWillPop();
      },
    );
  }

  void onWillPop() {
    print("LSY ONWILL POP");
    if (RouterCenterImpl().findMainRouter().isWithNative()) {
      FlutterBoost.singleton.closeCurrent();
    } else {
      Navigator.of(context).pop();
    }
  }
}
