/*
 * @author lsy
 * @date   2020/5/22
 **/
import 'package:flutter/material.dart';
import 'package:gm_flutter/commonModel/view/ActivePage.dart';

class DartUtil {
  //为了导包
}

extension WidgetExt on Widget {
  Widget margin(EdgeInsets edgeInsets, double width, double height) {
    return Container(
      width: width,
      height: height,
      margin: edgeInsets,
      child: this,
    );
  }

  Widget padding(EdgeInsets edgeInsets, double width, double height) {
    return Container(
      width: width,
      height: height,
      padding: edgeInsets,
      child: this,
    );
  }

  Widget gestureDetector(VoidCallback onTap) {
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      onTap: onTap,
      child: this,
    );
  }

  Widget minColumn(List<Widget> list) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: list,
    );
  }

  Widget toActive() {
    return ActivePage(this);
  }
}

extension StringExt on String {
  bool isPhone() {
    return new RegExp(
            '^((13[0-9])|(15[^4])|(166)|(17[0-8])|(18[0-9])|(19[8-9])|(147,145))\\d{8}\$')
        .hasMatch(this);
  }

  bool empty() {
    return this == null || this.isEmpty;
  }
}
