/*
 * @author lsy
 * @date   2020/7/2
 **/

import 'dart:ui';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/levelTwo/LevelTwoPage.dart';
import 'package:gm_flutter/ClueModel/page/top/TopModel.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'TopList.dart';

class TopPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => TopPageState();
}

class TopPageState extends BaseState<TopPage> with TickerProviderStateMixin {
  RefreshController refreshController = RefreshController();
  TabController tabController;
  TopModel _model = TopModel();

  @override
  void initState() {
    init();
    super.initState();
  }

  void init() {
    _model.init((i) {
      tabController = TabController(length: i, vsync: this);
      setState(() {});
    });
  }

  @override
  void dispose() {
    _model.dispose();
    refreshController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      body: baseStateView(
          MediaQuery.of(context).size.width,
          MediaQuery.of(context).size.height,
          _model.stateLive,
          Stack(
            children: <Widget>[
              Container(
                width: MediaQuery.of(context).size.width,
                height: MediaQuery.of(context).size.height,
                child: NotificationListener(
                  onNotification: (scrollNotification) {
                    if (scrollNotification is ScrollUpdateNotification &&
                        scrollNotification.metrics.axisDirection.index == 2) {
                      print("${scrollNotification}");
                    }
                    return false;
                  },
                  child: home(),
                ),
              ),
              baseSliverBack(() {
                Navigator.of(context).pop();
              }),
              baseSliverTitle("title", MediaQuery.of(context).size.width),
            ],
          ), () {
        init();
      }),
    );
  }

  Widget home() {
    List<Widget> list = [];
    var d = MediaQueryData.fromWindow(window).padding.top;
    for (int i = 0; i < _model.tabs.length; i++) {
      list.add(TopList(_model.tabs[i].id, 48 +d).toActive());
    }
    return DefaultTabController(
        length: _model.tabs.length,
        child: NestedScrollView(
            headerSliverBuilder:
                (BuildContext context, bool innerBoxIsScrolled) {
              return <Widget>[
                SliverOverlapAbsorber(
                    handle: NestedScrollView.sliverOverlapAbsorberHandleFor(
                        context),
                    sliver: baseSliverAppBar(_model.imageUrl)),
                SliverPersistentHeader(
                  pinned: true,
                  delegate: StickyTabBarDelegate(
                      child: Container(
                    height: 40,
                    color: Colors.white,
                    child: baseTabBar(null, getTabs(), (index) {
                      _model.selectTab(index);
                    }),
                  )),
                ),
              ];
            },
            body: TabBarView(children: list)));
  }

  List<Widget> getTabs() {
    List<Widget> list = [];
    for (int i = 0; i < _model.tabs.length; i++) {
      list.add(baseTabBarItem(_model.tabs[i].name,
          leftPadding: i == 0 ? 24 : 28,
          rightPadding: i == _model.tabs.length - 1 ? 24 : 28));
    }
    return list;
  }
}
