/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanProgressBar.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

class FilterView extends StatelessWidget {
  final Function(int high, int low) call;

  FilterView(this.call);

  int min = 0;
  int max = 0;

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      height: 186,
      child: Stack(
        children: <Widget>[
          Positioned(
            bottom: 74.5,
            left: 0,
            child: Container(
              width: MediaQuery.of(context).size.width,
              child: PlanProgressBar(
                0,
                5,
                0,
                10000,
                padding: 15,
              ),
            ),
          ),
          Positioned(
            top: 54.5,
            right: 15,
            child: baseText("无限", 12, Color(0xff3FB5AF)),
          ),
          Positioned(
            top: 54.5,
            left: 15,
            child: baseText("￥0", 12, Color(0xff3FB5AF)),
          ),
          Positioned(
            top: 25,
            left: 15,
            child: baseText("价格区间:", 13, Color(0xff666666)),
          ),
          Positioned(
            bottom: 0,
            child: Container(
              width: MediaQuery.of(context).size.width,
              height: 44.5,
              child: Row(
                children: <Widget>[
                  Expanded(
                    child: Container(
                      child: baseText("重置", 16, Color(0xff3FB5AF)),
                      alignment: Alignment.center,
                    ).gestureDetector(() {
                      SimpleEventBus.instance()
                          .notifyListener("PlanProgressBarState", "");
                    }),
                  ),
                  Expanded(
                    child: Container(
                      color: Color(0xff3FB5AF),
                      alignment: Alignment.center,
                      child: baseText("确定", 16, Colors.white),
                    ).gestureDetector(() {
                      call(max, min);
                    }),
                  )
                ],
              ),
            ),
          )
        ],
      ),
    );
  }
}
