/*
 * @author lsy
 * @date   2020/6/30
 **/
import 'dart:async';
import 'dart:io';
import 'dart:math';
import 'dart:ui';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/common/StickyTabBarDelegate.dart';
import 'package:gm_flutter/ClueModel/page/common/StickyTabBarDelegateWithSize.dart';
import 'package:gm_flutter/ClueModel/page/levelTwo/LevelTwoPage.dart';
import 'package:gm_flutter/ClueModel/page/plan/FilterView.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanBar.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanItem.dart';
import 'package:gm_flutter/ClueModel/page/plan/SortView.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/ClueModel/util/PosUtil.dart';
import 'package:gm_flutter/commonModel/App.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/popMenu/BaseMenuListener.dart';
import 'package:gm_flutter/commonModel/popMenu/BasePopMenu.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/util/WidgetUtil.dart';
import 'package:gm_flutter/commonModel/view/baseRefreshIndicator.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'PlanModel.dart';
import 'ProjectView.dart';

class PlanPage extends StatefulWidget {
  PlanPage(Map<String, dynamic> params) {}

  @override
  State<StatefulWidget> createState() => PlanState();
}

class PlanState extends BaseState<PlanPage> with TickerProviderStateMixin {
  PlanModel _model = PlanModel();
  TextEditingController _editingController = TextEditingController();
  FocusNode focusNode = FocusNode();
  RefreshController refreshController = RefreshController();

  BaseMenuListener projectMenuListener = BaseMenuListener();
  BaseMenuListener sortMenuListener = BaseMenuListener();
  BaseMenuListener filterMenuListener = BaseMenuListener();
  ChangeNotifier hideAllMenuListener = new ChangeNotifier();
  GlobalKey globalKey = GlobalKey();
  PlanBarView planBarView;
  double stateBarHeight;
  double topHeight;

  @override
  void initState() {
    print("LSY PLAN INIT");
//    DioUtil.getInstance().setProxy("172.30.9.128");
    _model.init(needCache: true);
    super.initState();
    planBarView =
        PlanBarView(_model.managerLive, clickIndex, hideAllMenuListener);
  }

  @override
  void dispose() {
    hideAllMenuListener.dispose();
    projectMenuListener.dispose();
    sortMenuListener.dispose();
    filterMenuListener.dispose();
    _model.dispose();
    focusNode.dispose();
    refreshController.dispose();
    _editingController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    stateBarHeight = MediaQueryData.fromWindow(window).padding.top;
    topHeight = stateBarHeight + kToolbarHeight;
    return Scaffold(
        body: MediaQuery.removePadding(
      removeTop: true,
      context: context,
      child: SafeArea(
          top: false,
          child: baseStateView(
              MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height,
              _model.stateLive,
              newHome(), () {
            _model.stateLive.notifyView(LOADING);
            _model.init();
          }, paddingTop: stateBarHeight + kToolbarHeight)),
    ));
  }

  Widget newHome() {
    return Container(
      width: MediaQuery.of(context).size.width,
      //主页 剪去tabbar高度
      height: MediaQuery.of(context).size.height - 50,
      child: Stack(
        children: <Widget>[
          Container(
            width: MediaQuery.of(context).size.width,
            height: MediaQuery.of(context).size.height - 50,
//                          child: child(),
            child: homeWarp(),
          ),
          StreamBuilder<List<double>>(
              stream: _model.backLive.stream,
              initialData: [0.0, 0.0, 0.0],
              builder: (c, data) {
                return Positioned(
                  left: 0.0,
                  top: 0.0,
                  child: Visibility(
                    visible: data.data[2] > 0.1,
                    child: Container(
                      width: MediaQuery.of(context).size.width,
                      height: MediaQuery.of(context).size.height,
                      child: Column(
                        children: <Widget>[
                          Container(
                            height:
                                data.data[1] - 45 < 0 ? 0 : data.data[1] - 45,
                            color: Colors.transparent,
                          ),
                          Container(
                            height: 45,
                            child: Row(
                              children: <Widget>[
                                Expanded(
                                  child: Container().gestureDetector(() {
                                    clickIndexOther(0);
                                  }),
                                ),
                                Expanded(
                                  child: Container().gestureDetector(() {
                                    clickIndexOther(1);
                                  }),
                                ),
                                Expanded(
                                  child: Container().gestureDetector(() {
                                    clickIndexOther(2);
                                  }),
                                ),
                              ],
                            ),
                          ),
                          Expanded(
                            child: Container(
                              color: Color.fromARGB(
                                  (data.data[2] * 153).toInt(), 0, 0, 0),
                            ).gestureDetector(() {
                              hideAllMenuListener.notifyListeners();
                            }),
                          )
                        ],
                      ),
                    ),
                  ),
                );
              }),
          StreamBuilder<List<double>>(
              stream: _model.posLive.stream,
              initialData: [0.0, 0.0],
              builder: (c, data) {
                return BasePopMenu(
                  leftPos: data.data[0],
                  topPos: data.data[1],
                  width: MediaQuery.of(context).size.width,
                  maxHeight: 450,
                  listener: projectMenuListener,
                  child: ProjectView(_model.projectData, (id, name) {
                    clickIndexOther(0);
                    _model.projectClick(id, name);
                  }),
                  proListener: (pro) {
                    _model.backProgress(pro, 0);
                  },
                );
              }),
          StreamBuilder<List<double>>(
            stream: _model.posLive.stream,
            initialData: [0.0, 0.0],
            builder: (c, data) {
              return BasePopMenu(
                leftPos: data.data[0],
                topPos: data.data[1],
                width: MediaQuery.of(context).size.width,
                maxHeight: 272,
                listener: sortMenuListener,
                child: SortView(_model.sortList, _model.sortPos, (index) {
                  clickIndexOther(1);
                  _model.sortClick(index);
                }),
                proListener: (pro) {
                  _model.backProgress(pro, 1);
                },
              );
            },
          ),
          StreamBuilder<List<double>>(
              stream: _model.posLive.stream,
              initialData: [0.0, 0.0],
              builder: (c, data) {
                return BasePopMenu(
                  leftPos: data.data[0],
                  topPos: data.data[1],
                  width: MediaQuery.of(context).size.width,
                  maxHeight: 186,
                  listener: filterMenuListener,
                  child: FilterView((max, min) {
                    clickIndexOther(2);
                    _model.filterClick(max, min);
                  }),
                  proListener: (pro) {
                    _model.backProgress(pro, 2);
                  },
                );
              }),
          StreamBuilder<bool>(
            stream: _model.showTab.stream,
            initialData: _model.showTab.data ?? false,
            builder: (c, data) {
              return Visibility(
                visible: data.data,
                child: Container(
                  color: Colors.white,
                  child: planBarView,
                ),
              );
            },
          ),
//          baseSliverBack((){
//            Navigator.pop(context);
//          })
        ],
      ),
    );
  }

  //搜索框
  Widget head() {
    return Container(
      height: topHeight,
//      child: Container(
//        margin: EdgeInsets.only(top: 48, left: 15, right: 15),
//        width: double.maxFinite,
//        height: 32,
//        child: TextField(
//          cursorColor: Color(0xff20BDBB),
//          style: TextStyle(fontSize: 12, color: Color(0xff999999)),
//          decoration: InputDecoration(
//              isDense: true,
//              prefixIcon: Container(
//                child: Container(
//                  margin: EdgeInsets.only(left: 12, right: 6),
//                  width: 13,
//                  height: 13,
//                  child: Image.asset("assets/search.png"),
//                ),
//              ),
//              prefixIconConstraints:
//                  BoxConstraints(maxWidth: 31, minWidth: 31, maxHeight: 13),
//              suffixIconConstraints:
//                  BoxConstraints(maxWidth: 56.5, maxHeight: 32),
//              suffixIcon: Container(
//                decoration: BoxDecoration(
//                  color: Color(0xff51CDC7),
//                  borderRadius: BorderRadius.circular(16),
//                ),
//                alignment: Alignment.center,
//                child: baseText("搜索", 14, Colors.white),
//              ).gestureDetector(() {
//                //TODO
//              }),
//              contentPadding:
//                  const EdgeInsets.symmetric(horizontal: 12.0, vertical: 10.0),
//              border: OutlineInputBorder(
//                  borderRadius: BorderRadius.circular(19.5),
//                  borderSide: BorderSide.none),
//              filled: true,
//              fillColor: Color(0xffF7F6FA),
//              hintStyle: TextStyle(fontSize: 12, color: Color(0xff999999)),
//              hintText: "切开双眼皮"),
//          maxLines: 1,
//          enableInteractiveSelection: true,
//          focusNode: focusNode,
//          autocorrect: false,
//          autofocus: false,
//          textInputAction: TextInputAction.search,
//          controller: _editingController,
//          minLines: null,
//          onEditingComplete: () {},
//          onSubmitted: (text) {},
//        ),
//      ),
    );
  }

  Widget homeWarp() {
    return BaseNestedScrollViewRefreshIndicator(
        onRefresh: () async {
          Completer completer = new Completer();
          _model.init(call: () {
            refreshController.resetNoData();
            completer.complete();
          });
          return completer.future;
        },
        child: home());
  }

  Widget home() {
    return NestedScrollView(
        headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
          return <Widget>[
            SliverOverlapAbsorber(
                handle:
                    NestedScrollView.sliverOverlapAbsorberHandleFor(context),
                sliver: baseSliverAppBar(null,
                    height: kToolbarHeight + stateBarHeight, needpic: false)),
            SliverList(
                delegate: SliverChildBuilderDelegate((BuildContext c, int i) {
              if (i == 0) {
                return Container(
                  height: kToolbarHeight,
                );
              }
              return towPic();
            }, childCount: 2)),
            SliverPersistentHeader(
              pinned: true,
              delegate:
                  StickyTabBarDelegateWithSize(child: planBar(), height: 45),
            )
          ];
        },
        body: child());
  }

  Widget child() {
    return StreamBuilder<Pair<int, List<Plans>>>(
      stream: _model.feedsLive.stream,
      initialData: _model.feedsLive.data ?? Pair(LOADING, null),
      builder: (c, data) {
        if (data.data.first == FAIL) {
          return errorItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height, () {
            _model.feedsLive.notifyView(Pair(LOADING, null));
            _model.refreshFeed(true);
          });
        }
        if (data.data.first == LOADING) {
          return Container(
            color: Colors.white,
            width: MediaQuery.of(context).size.width,
            height: MediaQuery.of(context).size.height,
            child: loadingItem(),
          );
        }
        if (data.data.first == EMPTY) {
          return emptyItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height);
        }
        return Container(
            color: Color(0xffF7F6FA),
            child: baseRefreshView(
                refreshController,
                () {
                  _model.refreshFeed(true, controller: refreshController);
                },
                null,
                null,
                customScrollView: CustomScrollView(
                  physics: ClampingScrollPhysics(),
                  slivers: <Widget>[
                    SliverList(
                      delegate: SliverChildBuilderDelegate(
                        (BuildContext context, int index) {
                          if (data.data.second.length == 0) {
                            if (_model.page != 1) {
                              refreshController.loadNoData();
                            }
                          } else {
                            refreshController.loadComplete();
                          }
                          return PlanItem(_model.feedDatas[index], index, true);
                        },
                        childCount: _model.feedDatas.length,
                      ),
                    )
                  ],
                ),
                onLoading: () {
                  _model.loadMore();
                },
                pullDown: false,
                pullUp: true));
      },
    );
  }

  Widget towPic() {
    return Container(
      height: 90,
      margin: EdgeInsets.only(left: 15, right: 15, top: 15, bottom: 10),
      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              child: StreamBuilder<List<Ranks>>(
                stream: _model.picLive.stream,
                initialData: _model.picLive.data ?? null,
                builder: (c, data) {
                  return ClipRRect(
                      borderRadius: BorderRadius.circular(3),
                      child: CachedNetworkImage(
                        imageUrl:
                            data.data == null ? "" : data.data[0].icon ?? "",
                        fit: BoxFit.cover,
                      )).gestureDetector(() {
                    Map<String, dynamic> map = {
                      "rank_type": "0",
                      "id": "${data.data[1].id}"
                    };
                    RouterCenterImpl()
                        .findMainRouter()
                        .jumpPage(context, "favor_plan", map, false);
                  });
                },
              ),
            ),
          ),
          Container(
            width: 10,
          ),
          Expanded(
            child: Container(
              child: StreamBuilder<List<Ranks>>(
                stream: _model.picLive.stream,
                initialData: _model.picLive.data ?? null,
                builder: (c, data) {
                  return ClipRRect(
                      borderRadius: BorderRadius.circular(3),
                      child: CachedNetworkImage(
                        imageUrl:
                            data.data == null ? "" : data.data[1].icon ?? "",
                        fit: BoxFit.cover,
                      )).gestureDetector(() {
                    Map<String, dynamic> map = {
                      "rank_type": "1",
                      "id": "${data.data[1].id}"
                    };
                    RouterCenterImpl()
                        .findMainRouter()
                        .jumpPage(context, "hot_plan", map, false);
                  });
                },
              ),
            ),
          )
        ],
      ),
    );
  }

  Widget planBar() {
    return Container(
      color: Colors.white,
      key: globalKey,
      child: planBarView,
    );
  }

  void clickIndexOther(int index) {
    if (index == planBarView.showIndex) {
      planBarView.showIndex = -1;
    } else {
      planBarView.showIndex = index;
    }
    _model.managerLive
        .notifyView(_model.managerLive.data ?? planBarView.normalData);
    clickIndex(planBarView.showIndex);
  }

  void clickIndex(int index) {
    var topPos = PosUtil.findPos(globalKey);

    double bottom =
//        WidgetUtil.buttonLeftMenuPosition(globalKey.currentContext)?.top ??
        topPos == null ? 0.0 : topPos.dy + 45;
    if (bottom < 45) {
      bottom = 45;
    }
    _model.menuBottom = bottom;
    if (_model.menuIndex == index || _model.menuIndex == -1) {
      _model.needChangBack = true;
    } else {
      _model.needChangBack = false;
    }
    _model.menuIndex = index;
    _model.posLive.notifyView([0.0, bottom]);
    if (index == -1) {
      projectMenuListener.hide();
      sortMenuListener.hide();
      filterMenuListener.hide();
    } else if (index == 0) {
      projectMenuListener.show();
      sortMenuListener.hide();
      filterMenuListener.hide();
    } else if (index == 1) {
      projectMenuListener.hide();
      sortMenuListener.show();
      filterMenuListener.hide();
    } else if (index == 2) {
      projectMenuListener.hide();
      sortMenuListener.hide();
      filterMenuListener.show();
    }
  }
}
