/*
 * @author lsy
 * @date   2020/7/4
 **/
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class LevelOneListModel extends BaseModel {
  int plan_id;
  String tab_type;
  int page = 1;

  LiveData<int> stateLive = LiveData();
  LiveData<List<Cards>> cardsLive = LiveData();
  List<Cards> data = [];

  RxDispose rxDispose = RxDispose();

  void refreshView(bool clear, {RefreshController refreshListener}) {
    if (clear) {
      data.clear();
      page = 1;
    }
    ClueApiImpl.getInstance()
        .getLevelOneList(
            DioUtil.getInstance().getDio(), plan_id, tab_type, page)
        .listen((event) {
          if (event.error == 0) {
            if ((event.data.cards == null || event.data.cards.isEmpty) &&
                page == 1) {
              stateLive.notifyView(EMPTY);
            } else {
              data.addAll(event.data.cards);
              cardsLive.notifyView(data);
              stateLive.notifyView(ENDLOADING);
            }
          } else {
            NativeToast.showNativeToast(event.message);
            stateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  @override
  void dispose() {
    rxDispose.dispose();
    stateLive.dispost();
    cardsLive.dispost();
  }

  void loadMore() {
    page++;
    refreshView(false);
  }
}
